/*
 * Decompiled with CFR 0.152.
 */
package anon.anonudp.mixmessage.crypto;

import anon.anonudp.exception.SymmetricKeyCreationFailed;
import anon.anonudp.mixmessage.crypto.EccGroup713;
import anon.anonudp.mixmessage.crypto.PrivateKey;
import anon.anonudp.mixmessage.crypto.PublicKey;
import java.math.BigInteger;

class BlindingFactor {
    private BigInteger underlyingValue;

    BlindingFactor(PrivateKey privateKey) {
        this.underlyingValue = privateKey.getUnderlyingValue();
    }

    BlindingFactor(PublicKey publicKey) throws SymmetricKeyCreationFailed {
        this(publicKey.toSymmetricKey());
    }

    BlindingFactor(byte[] symmetricKey) throws SymmetricKeyCreationFailed {
        this.underlyingValue = EccGroup713.hb(symmetricKey);
    }

    BigInteger getUnderlyingValue() {
        return this.underlyingValue;
    }
}

