/*
 * Decompiled with CFR 0.152.
 */
package infoservice;

import anon.infoservice.Database;
import anon.util.MyStringBuilder;
import infoservice.japforwarding.ForwarderDBEntry;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class ISRuntimeStatistics {
    static volatile long ms_lTCPIPConnections = 0L;
    static volatile long ms_lNrOfGetMixCascadeStatusRequests = 0L;
    static volatile long ms_lNrOfPosts = 0L;
    static volatile long ms_lNrOfGets = 0L;
    static volatile long ms_lNrOfUnknownRequests = 0L;
    static volatile long ms_lNrOfOtherMethod = 0L;
    static volatile long ms_lNrOfGetMixinfoRequests = 0L;
    static volatile long ms_lNrOfGetCascadeinfoRequests = 0L;
    static volatile long ms_lNrOfGetInfoservicesRequests = 0L;
    static volatile long ms_lNrOfGetInfoserviceserialsRequests = 0L;
    static volatile long ms_lNrOfGetCascadeserialsRequests = 0L;
    static volatile long ms_lNrOfGetCascadesRequests = 0L;
    static volatile long ms_lNrOfGetForwarding = 0L;
    static volatile long ms_lNrOfGetStatus = 0L;
    static volatile long ms_lNrOfGetPaymentRequests = 0L;
    static volatile long ms_lNrOfPerformanceInfoRequests = 0L;
    static volatile long ms_lNrOfGetTorNodesRequests = 0L;
    static volatile long ms_lNrOfGetMinJapVersion = 0L;
    static NumberFormat ms_NumberFormat = NumberFormat.getInstance();
    private static Hashtable[] ms_hashClientVersions = new Hashtable[24];
    private static int ms_currentHour;

    ISRuntimeStatistics() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void putClientVersion(String a_property, String a_value) {
        if (a_property == null || a_value == null) {
            return;
        }
        int hour = Calendar.getInstance().get(11);
        Hashtable hashtable = ms_hashClientVersions[hour];
        synchronized (hashtable) {
            if (ms_currentHour != hour) {
                ms_hashClientVersions[hour].clear();
                ms_currentHour = hour;
            }
            ISRuntimeStatistics.putClientVersion(a_property, a_value, ms_hashClientVersions[hour], BigInteger.valueOf(1L));
        }
    }

    private static String removeVersionAppendix(String a_version, int a_indexStart) {
        int indexEnd = a_version.indexOf("/");
        if (indexEnd < 0) {
            a_version = a_version.substring(0, a_indexStart);
        } else if (a_indexStart < indexEnd) {
            a_version = a_version.substring(0, a_indexStart) + " " + a_version.substring(indexEnd, a_version.length());
        }
        return a_version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putClientVersion(String a_property, String a_value, Hashtable a_hashtable, BigInteger a_addedValue) {
        if (a_property.length() > 100 || a_value.length() > 100) {
            return;
        }
        a_property = a_property.toLowerCase();
        if (a_value.endsWith("Sun Microsystems Inc.")) {
            a_value = a_value.substring(0, a_value.lastIndexOf("Sun Microsystems Inc.")).trim();
        }
        if (a_value.endsWith("/")) {
            a_value = a_value.substring(0, a_value.length() - 1).trim();
        }
        if (a_property.equals("statistics-java")) {
            int indexStart = a_value.indexOf("_");
            if (indexStart > 0) {
                a_value = ISRuntimeStatistics.removeVersionAppendix(a_value, indexStart);
            }
            if ((indexStart = a_value.indexOf("-")) > 0) {
                a_value = ISRuntimeStatistics.removeVersionAppendix(a_value, indexStart);
            }
        }
        Hashtable hashtable = a_hashtable;
        synchronized (hashtable) {
            BigInteger count;
            Hashtable<String, BigInteger> hashProperty = (Hashtable<String, BigInteger>)a_hashtable.get(a_property);
            if (hashProperty == null) {
                if (a_hashtable.size() > 20) {
                    return;
                }
                hashProperty = new Hashtable<String, BigInteger>();
            }
            if ((count = (BigInteger)hashProperty.get(a_value)) == null) {
                if (hashProperty.size() > 100) {
                    return;
                }
                count = a_addedValue;
            } else {
                count = count.add(a_addedValue);
            }
            hashProperty.put(a_value, count);
            a_hashtable.put(a_property, hashProperty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getAsHTML() {
        String strValue;
        Enumeration<Object> enumValues;
        Hashtable hashValue;
        String strProperty;
        Enumeration enumProperties;
        MyStringBuilder sb = new MyStringBuilder(512);
        sb.append("<table>");
        sb.append("<tr><td>TCP/IP Connections received: </td><td>");
        sb.append(ms_NumberFormat.format(ms_lTCPIPConnections));
        sb.append("</td></tr><tr><td>Total GET Requests: </td><td>");
        sb.append(ms_NumberFormat.format(ms_lNrOfGets));
        sb.append("</td></tr><tr><td>Total POST Requests: </td><td>");
        sb.append(ms_NumberFormat.format(ms_lNrOfPosts));
        sb.append("</td></tr><tr><td>Total other than GET/POST Requests: </td><td>");
        sb.append(ms_NumberFormat.format(ms_lNrOfOtherMethod));
        sb.append("</td></tr><tr><td><br></td><td>");
        sb.append("</td></tr><tr><td>GET Requests for /mixcascadestatus/: </td><td>");
        sb.append(ms_NumberFormat.format(ms_lNrOfGetMixCascadeStatusRequests));
        sb.append("</td></tr><tr><td>GET Requests for /cascadeserials: </td><td>");
        sb.append(ms_NumberFormat.format(ms_lNrOfGetCascadeserialsRequests));
        sb.append("</td></tr><tr><td>GET Requests for /cascades: </td><td>");
        sb.append(ms_NumberFormat.format(ms_lNrOfGetCascadesRequests));
        sb.append("</td></tr><tr><td>GET Requests for /infoserviceserials: </td><td>");
        sb.append(ms_NumberFormat.format(ms_lNrOfGetInfoserviceserialsRequests));
        sb.append("</td></tr><tr><td>GET Requests for /infoservices: </td><td>");
        sb.append(ms_NumberFormat.format(ms_lNrOfGetInfoservicesRequests));
        sb.append("</td></tr><tr><td>GET Requests for /mixinfo/: </td><td>");
        sb.append(ms_NumberFormat.format(ms_lNrOfGetMixinfoRequests));
        sb.append("</td></tr><tr><td>GET Requests for /cascadeinfo/: </td><td>");
        sb.append(ms_NumberFormat.format(ms_lNrOfGetCascadeinfoRequests));
        sb.append("</td></tr><tr><td>GET Requests for Forwarding: </td><td>");
        sb.append(ms_NumberFormat.format(ms_lNrOfGetForwarding));
        sb.append("</td></tr><tr><td>GET Requests for /tornodes: </td><td>");
        sb.append(ms_NumberFormat.format(ms_lNrOfGetTorNodesRequests));
        sb.append("</td></tr><tr><td>GET Requests for /currentjapversion: </td><td>");
        sb.append(ms_NumberFormat.format(ms_lNrOfGetMinJapVersion));
        sb.append("</td></tr><tr><td>GET Requests for /status: </td><td>");
        sb.append(ms_NumberFormat.format(ms_lNrOfGetStatus));
        sb.append("</td></tr><tr><td>GET Requests for /performanceinfo: </td><td>");
        sb.append(ms_NumberFormat.format(ms_lNrOfPerformanceInfoRequests));
        sb.append("</td></tr><tr><td>GET Requests for Payment: </td><td>");
        sb.append(ms_NumberFormat.format(ms_lNrOfGetPaymentRequests));
        sb.append("</td></tr><tr><td>Unknown Requests: </td><td>");
        sb.append(ms_NumberFormat.format(ms_lNrOfUnknownRequests));
        sb.append("</td></tr><tr><td><br></td><td>");
        sb.append("</td></tr><tr><td>Active forwarders: </td><td>");
        sb.append(ms_NumberFormat.format(Database.getInstance(ForwarderDBEntry.class).getNumberOfEntries()));
        sb.append("</td></tr><tr><td><br></td><td>");
        Hashtable hashVersionStrings = new Hashtable();
        for (int i = 0; i < ms_hashClientVersions.length; ++i) {
            Hashtable hashtable = ms_hashClientVersions[i];
            synchronized (hashtable) {
                enumProperties = ms_hashClientVersions[i].keys();
                while (enumProperties.hasMoreElements()) {
                    strProperty = (String)enumProperties.nextElement();
                    hashValue = (Hashtable)ms_hashClientVersions[i].get(strProperty);
                    enumValues = hashValue.keys();
                    while (enumValues.hasMoreElements()) {
                        strValue = (String)enumValues.nextElement();
                        ISRuntimeStatistics.putClientVersion(strProperty, strValue, hashVersionStrings, (BigInteger)hashValue.get(strValue));
                    }
                }
                continue;
            }
        }
        BigInteger allStatisticsCount = BigInteger.valueOf(0L);
        enumProperties = hashVersionStrings.keys();
        while (enumProperties.hasMoreElements()) {
            BigInteger currentCount;
            strProperty = (String)enumProperties.nextElement();
            hashValue = (Hashtable)hashVersionStrings.get(strProperty);
            sb.append("</td></tr><tr><td>" + strProperty + ": </td><td>");
            BigInteger totalCounts = BigInteger.valueOf(0L);
            Vector<String> vecValues = new Vector<String>();
            enumValues = hashValue.keys();
            while (enumValues.hasMoreElements()) {
                int i;
                strValue = (String)enumValues.nextElement();
                currentCount = (BigInteger)hashValue.get(strValue);
                for (i = 0; i < vecValues.size() && currentCount.compareTo((BigInteger)hashValue.get(vecValues.elementAt(i))) < 0; ++i) {
                }
                vecValues.insertElementAt(strValue, i);
                totalCounts = totalCounts.add(currentCount);
            }
            allStatisticsCount = allStatisticsCount.max(totalCounts);
            enumValues = vecValues.elements();
            while (enumValues.hasMoreElements()) {
                strValue = (String)enumValues.nextElement();
                currentCount = (BigInteger)hashValue.get(strValue);
                currentCount = currentCount.multiply(BigInteger.valueOf(10000L));
                currentCount = currentCount.divide(totalCounts);
                sb.append(strValue + " (" + currentCount.doubleValue() / 100.0 + "%)");
                if (!enumValues.hasMoreElements()) continue;
                sb.append(", ");
            }
        }
        sb.append("</td></tr><tr><td>statistics total: </td><td>" + ms_NumberFormat.format(allStatisticsCount.longValue()));
        sb.append("</td></tr><tr><td><br></td><td>");
        sb.append("</td></tr><tr><td>Total Memory: </td><td>");
        sb.append(ms_NumberFormat.format(Runtime.getRuntime().totalMemory()));
        sb.append("</td></tr><tr><td>Free Memory: </td><td>");
        sb.append(ms_NumberFormat.format(Runtime.getRuntime().freeMemory()));
        sb.append("</td></tr></table>");
        return sb.toString();
    }

    static {
        for (int i = 0; i < ms_hashClientVersions.length; ++i) {
            ISRuntimeStatistics.ms_hashClientVersions[i] = new Hashtable();
        }
        ms_currentHour = Calendar.getInstance().get(11);
    }
}

