/*
 * Decompiled with CFR 0.152.
 */
package infoservice.agreement.multicast.messages;

import anon.util.Base64;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import javax.naming.directory.InvalidAttributesException;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class CommitmentMessage {
    private String m_randomOne;
    private String m_randomTwo;
    private String m_proposal;
    private char m_separatorCharacter;

    public CommitmentMessage() {
        this.m_randomOne = Long.toString(new Random().nextLong());
        this.m_randomTwo = Long.toString(new Random().nextLong());
        this.m_proposal = Long.toString(new Random().nextLong());
        this.m_separatorCharacter = (char)35;
    }

    public CommitmentMessage(String a_stringconcat) throws InvalidAttributesException {
        this.m_separatorCharacter = (char)35;
        Vector stringVector = this.deconcat(a_stringconcat);
        if (stringVector.size() != 3) {
            throw new InvalidAttributesException("Size of Vector mustbe 3. But is " + stringVector.size());
        }
        this.m_randomOne = (String)stringVector.get(0);
        this.m_randomTwo = (String)stringVector.get(1);
        this.m_proposal = (String)stringVector.get(2);
    }

    public static synchronized String extractHashFromHashAndRandomOneConcatenation(String a_concat) throws InvalidAttributesException {
        Vector stringVector = CommitmentMessage.deconcatenate(a_concat);
        if (stringVector.size() != 2) {
            throw new InvalidAttributesException("Size of Vector mustbe 2 But is " + stringVector.size());
        }
        return (String)stringVector.get(0);
    }

    public static synchronized String extractRandomOneFromHashAndRandomOneConcatenation(String a_concat) throws InvalidAttributesException {
        Vector stringVector = CommitmentMessage.deconcatenate(a_concat);
        if (stringVector.size() != 2) {
            throw new InvalidAttributesException("Size of Vector mustbe 2 But is " + stringVector.size());
        }
        return (String)stringVector.get(1);
    }

    private static Vector deconcatenate(String a_string) {
        Vector<String> result = new Vector<String>();
        String str = new String();
        char m_trenner = '#';
        for (int i = 0; i < a_string.length(); ++i) {
            char c = a_string.charAt(i);
            if (c == m_trenner && i < a_string.length() - 1 && a_string.charAt(i + 1) == m_trenner) {
                str = str + String.valueOf(c);
                ++i;
                continue;
            }
            if (c == m_trenner) {
                result.add(str);
                str = new String();
                continue;
            }
            str = str + String.valueOf(c);
        }
        return result;
    }

    public String getConcatenation() {
        Vector<String> stringVector = new Vector<String>(3);
        stringVector.add(this.m_randomOne);
        stringVector.add(this.m_randomTwo);
        stringVector.add(this.m_proposal);
        return this.concat(stringVector);
    }

    public String getHashCode() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.m_randomOne);
        buf.append(this.m_randomTwo);
        buf.append(this.m_proposal);
        SHA1Digest digest = new SHA1Digest();
        byte[] proposalBytes = buf.toString().getBytes();
        digest.update(proposalBytes, 0, proposalBytes.length);
        byte[] tmp = new byte[digest.getDigestSize()];
        digest.doFinal(tmp, 0);
        return Base64.encode(tmp, false);
    }

    public String getHashValueAndRandomOne() {
        Vector<String> stringVector = new Vector<String>(2);
        stringVector.add(this.getHashCode());
        stringVector.add(this.m_randomOne);
        return this.concat(stringVector);
    }

    public String getProposal() {
        return this.m_proposal;
    }

    public String getRandomOne() {
        return this.m_randomOne;
    }

    public String getRandomTwo() {
        return this.m_randomTwo;
    }

    public char getSeparator() {
        return this.m_separatorCharacter;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("R1: " + this.m_randomOne + "\n");
        buf.append("R2: " + this.m_randomTwo + "\n");
        buf.append("Proposal: " + this.m_proposal + "\n");
        buf.append("Hash: " + this.getHashCode() + "\n");
        return buf.toString();
    }

    private String concat(Vector a_strArray) {
        String result = "";
        String tmp = "";
        Enumeration en = a_strArray.elements();
        while (en.hasMoreElements()) {
            tmp = (String)en.nextElement();
            for (int i = 0; i < tmp.length(); ++i) {
                char c = tmp.charAt(i);
                result = c == this.m_separatorCharacter ? result + String.valueOf(c) + String.valueOf(c) : result + String.valueOf(c);
            }
            result = result + String.valueOf(this.m_separatorCharacter);
        }
        return result;
    }

    private Vector deconcat(String a_string) {
        Vector<String> result = new Vector<String>();
        String str = new String();
        for (int i = 0; i < a_string.length(); ++i) {
            char c = a_string.charAt(i);
            if (c == this.m_separatorCharacter && i < a_string.length() - 1 && a_string.charAt(i + 1) == this.m_separatorCharacter) {
                str = str + String.valueOf(c);
                ++i;
                continue;
            }
            if (c == this.m_separatorCharacter) {
                result.add(str);
                str = new String();
                continue;
            }
            str = str + String.valueOf(c);
        }
        return result;
    }
}

