/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import java.util.Calendar;
import java.util.Date;

public class Validity {
    private Calendar m_validFrom;
    private Calendar m_validTo;
    private static final int TEMPORARY_VALIDITY_IN_MINUTES = 10;

    public Validity(Calendar a_validFrom, int a_validityInYears) {
        this(a_validFrom, Validity.createValidTo(a_validFrom, a_validityInYears));
    }

    public Validity(Calendar a_validFrom, Calendar a_validTo) {
        if (a_validFrom == null || a_validTo == null) {
            throw new IllegalArgumentException("Calendars for validity must not be null!");
        }
        this.m_validFrom = (Calendar)a_validFrom.clone();
        this.m_validTo = a_validTo.before(a_validFrom) ? this.m_validFrom : (Calendar)a_validTo.clone();
    }

    public Date getValidFrom() {
        return this.m_validFrom.getTime();
    }

    public Date getValidTo() {
        return this.m_validTo.getTime();
    }

    public boolean isValid(Date a_date) {
        return !a_date.before(this.getValidFrom()) && !a_date.after(this.getValidTo());
    }

    private static Calendar createValidTo(Calendar a_validFrom, int a_validityInYears) {
        if (a_validFrom == null) {
            return null;
        }
        Calendar validTo = (Calendar)a_validFrom.clone();
        if (a_validityInYears < 0) {
            validTo.add(12, 10);
        } else {
            validTo.add(1, a_validityInYears);
        }
        return validTo;
    }
}

