/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.CertPath;
import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.JAPCertificate;
import anon.crypto.MultiCertPath;
import anon.crypto.PKCS12;
import anon.crypto.XMLSignatureElement;
import anon.util.Base64;
import anon.util.Util;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.SignatureException;
import java.util.Enumeration;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class XMLSignature {
    private static final String XML_ELEMENT_NAME = "Signature";
    private Vector m_signatureElements = new Vector();
    private MultiCertPath m_multiCertPath;
    private String m_xoredID;

    private XMLSignature() {
    }

    public int countSignatures() {
        return this.m_signatureElements.size();
    }

    protected Vector getSignatureElements() {
        Vector<Element> elements = new Vector<Element>();
        Enumeration signatures = this.m_signatureElements.elements();
        while (signatures.hasMoreElements()) {
            XMLSignatureElement currentSignature = (XMLSignatureElement)signatures.nextElement();
            elements.addElement(currentSignature.getSignatureElement());
        }
        return elements;
    }

    public MultiCertPath getMultiCertPath() {
        return this.m_multiCertPath;
    }

    private CertPath[] getCertPaths() {
        CertPath[] paths = new CertPath[this.m_signatureElements.size()];
        for (int i = 0; i < this.m_signatureElements.size(); ++i) {
            paths[i] = ((XMLSignatureElement)this.m_signatureElements.elementAt(i)).getCertPath();
        }
        return paths;
    }

    public String getXORofSKIs() {
        return this.m_xoredID;
    }

    private void calculateXORofSKIs() {
        Vector<JAPCertificate> certificates = new Vector<JAPCertificate>();
        Enumeration signatureElements = this.m_signatureElements.elements();
        while (signatureElements.hasMoreElements()) {
            certificates.addElement(((XMLSignatureElement)signatureElements.nextElement()).getCertPath().getFirstCertificate());
        }
        this.m_xoredID = JAPCertificate.calculateXORofSKIs(certificates);
    }

    public boolean isVerified() {
        if (this.m_multiCertPath == null) {
            return false;
        }
        return this.m_multiCertPath.isVerified();
    }

    public static XMLSignature sign(Node a_node, PKCS12 a_certificate, int a_documentClass) throws XMLParseException {
        return XMLSignature.signInternal(a_node, Util.toVector(a_certificate), a_documentClass);
    }

    public synchronized boolean addCertificate(JAPCertificate a_certificate) {
        if (a_certificate != null) {
            Enumeration signatures = this.m_signatureElements.elements();
            while (signatures.hasMoreElements()) {
                XMLSignatureElement current = (XMLSignatureElement)signatures.nextElement();
                if (!current.addCertificate(a_certificate)) continue;
                return true;
            }
        }
        return false;
    }

    public static XMLSignature sign(Node a_node, IMyPrivateKey a_privateKey, int a_documentClass) throws XMLParseException {
        return XMLSignature.signInternal(a_node, Util.toVector(a_privateKey), a_documentClass);
    }

    public static XMLSignature multiSign(Node a_node, Vector a_privateKeys, int a_documentClass) throws XMLParseException {
        return XMLSignature.signInternal(a_node, a_privateKeys, a_documentClass);
    }

    public static String getHashValueOfElement(Node nodeToHash) {
        byte[] digestValue = null;
        try {
            digestValue = MessageDigest.getInstance("SHA-1").digest(XMLSignature.toCanonical(nodeToHash));
        }
        catch (Exception ex) {
            LogHolder.log(4, LogType.PAY, "could not create hash value of node");
            return null;
        }
        return Base64.encode(digestValue, false);
    }

    public static String getEncodedHashValue(Element nodeToHash) {
        return XMLSignature.getHashValueOfElement(nodeToHash);
    }

    private static XMLSignature signInternal(Node a_node, Vector a_privateKeys, int a_documentClass) throws XMLParseException {
        XMLSignature xmlSignature;
        block16: {
            Element elementToSign;
            PKCS12 signCert = null;
            if (a_node == null || a_privateKeys == null || a_privateKeys.size() == 0) {
                return null;
            }
            if (a_node instanceof Document) {
                elementToSign = ((Document)a_node).getDocumentElement();
            } else if (a_node instanceof Element) {
                elementToSign = (Element)a_node;
            } else {
                return null;
            }
            xmlSignature = new XMLSignature();
            Vector oldSignatureNodes = XMLSignature.removeSignatureFromInternal(elementToSign);
            byte[] canonicalBuff = XMLSignature.toCanonical(elementToSign);
            SHA1Digest digest = new SHA1Digest();
            digest.update(canonicalBuff, 0, canonicalBuff.length);
            byte[] digestValue = new byte[digest.getDigestSize()];
            digest.doFinal(digestValue, 0);
            Enumeration keys = a_privateKeys.elements();
            try {
                while (keys.hasMoreElements()) {
                    IMyPrivateKey signKey;
                    Object obj = keys.nextElement();
                    if (obj instanceof IMyPrivateKey) {
                        signCert = null;
                        signKey = (IMyPrivateKey)obj;
                    } else {
                        signCert = (PKCS12)obj;
                        signKey = signCert.getPrivateKey();
                    }
                    XMLSignatureElement sigElement = new XMLSignatureElement(xmlSignature, elementToSign, signKey, digestValue);
                    if (signCert != null) {
                        sigElement.addCertificate(signCert.getX509Certificate());
                    }
                    xmlSignature.m_signatureElements.addElement(sigElement);
                    sigElement.verify(a_node, a_documentClass, new Vector());
                }
                if (a_documentClass == 0) break block16;
                try {
                    xmlSignature.m_multiCertPath = new MultiCertPath(xmlSignature.getCertPaths(), a_documentClass);
                }
                catch (IllegalArgumentException iae) {
                    LogHolder.log(2, LogType.CRYPTO, iae);
                    return null;
                }
                xmlSignature.calculateXORofSKIs();
            }
            catch (Exception a_e) {
                LogHolder.log(2, LogType.CRYPTO, "Could not sign XML document!", a_e);
                if (xmlSignature.countSignatures() != 0) {
                    XMLSignature.removeSignatureFromInternal(elementToSign);
                }
                if (oldSignatureNodes != null) {
                    Enumeration oldSigs = oldSignatureNodes.elements();
                    while (oldSigs.hasMoreElements()) {
                        elementToSign.appendChild((Element)oldSigs.nextElement());
                    }
                }
                return null;
            }
        }
        return xmlSignature;
    }

    public static XMLSignature getVerified(Node a_node, int a_documentType, Vector a_directCertificatePaths) throws XMLParseException, SignatureException {
        XMLSignature signature = XMLSignature.findXMLSignature(a_node);
        if (signature == null) {
            LogHolder.log(7, LogType.CRYPTO, "Could not find the <Signature> node!");
            return null;
        }
        Enumeration signatures = signature.m_signatureElements.elements();
        while (signatures.hasMoreElements()) {
            XMLSignatureElement currentSignature = (XMLSignatureElement)signatures.nextElement();
            if (currentSignature.verify(a_node, a_documentType, a_directCertificatePaths)) continue;
            throw new SignatureException("No verifier for a Signature found!");
        }
        try {
            signature.m_multiCertPath = new MultiCertPath(signature.getCertPaths(), a_documentType);
        }
        catch (IllegalArgumentException iae) {
            LogHolder.log(6, LogType.CRYPTO, iae);
            return null;
        }
        signature.calculateXORofSKIs();
        return signature;
    }

    public static boolean verifyFast(Node a_node, Vector a_publicKeys) {
        Enumeration keys = a_publicKeys.elements();
        while (keys.hasMoreElements()) {
            IMyPublicKey currentKey = (IMyPublicKey)keys.nextElement();
            if (!XMLSignature.verifyFast(a_node, currentKey)) continue;
            return true;
        }
        return false;
    }

    public static boolean verifyFast(Node a_node, IMyPublicKey a_publicKey) {
        try {
            return XMLSignature.verify(a_node, a_publicKey) != null;
        }
        catch (Throwable t) {
            LogHolder.log(2, LogType.CRYPTO, t);
            return false;
        }
    }

    public static XMLSignature verify(Node a_node, IMyPublicKey a_publicKey) throws XMLParseException {
        XMLSignature xmlSignature = XMLSignature.findXMLSignature(a_node);
        if (xmlSignature == null) {
            LogHolder.log(3, LogType.CRYPTO, "No signature node found!");
            return null;
        }
        Enumeration signatures = xmlSignature.m_signatureElements.elements();
        while (signatures.hasMoreElements()) {
            try {
                XMLSignatureElement signature = (XMLSignatureElement)signatures.nextElement();
                if (!signature.verifyFast(a_node, a_publicKey)) continue;
                return xmlSignature;
            }
            catch (Throwable t) {
            }
        }
        return null;
    }

    public static XMLSignature getUnverified(Node a_node) throws XMLParseException {
        if (a_node == null) {
            return null;
        }
        XMLSignature signature = XMLSignature.findXMLSignature(a_node);
        return signature;
    }

    public static boolean removeSignatureFrom(Node a_node) {
        return XMLSignature.removeSignatureFromInternal(a_node) != null;
    }

    private static Vector removeSignatureFromInternal(Node a_node) {
        Node nextRemovedNode;
        Element element;
        Vector<Element> nodes = new Vector<Element>();
        Element signatureNode = null;
        if (a_node instanceof Document) {
            element = ((Document)a_node).getDocumentElement();
        } else if (a_node instanceof Element) {
            element = (Element)a_node;
        } else {
            return null;
        }
        while ((nextRemovedNode = XMLUtil.getFirstChildByName(element, XML_ELEMENT_NAME)) != null) {
            try {
                signatureNode = (Element)element.removeChild(nextRemovedNode);
                nodes.addElement(signatureNode);
            }
            catch (ClassCastException a_e) {}
        }
        if (nodes.size() == 0) {
            return null;
        }
        return nodes;
    }

    private static XMLSignature findXMLSignature(Node a_node) throws XMLParseException {
        Element elementVerified;
        if (a_node == null) {
            throw new XMLParseException("##__null__##");
        }
        if (a_node instanceof Document) {
            elementVerified = ((Document)a_node).getDocumentElement();
        } else if (a_node instanceof Element) {
            elementVerified = (Element)a_node;
        } else {
            return null;
        }
        Node signatureNode = XMLUtil.getFirstChildByName(elementVerified, XML_ELEMENT_NAME);
        XMLSignature xmlSignature = new XMLSignature();
        while (signatureNode != null) {
            try {
                XMLSignatureElement sigElement = new XMLSignatureElement(xmlSignature, (Element)signatureNode);
                xmlSignature.m_signatureElements.addElement(sigElement);
            }
            catch (ClassCastException a_e) {
                // empty catch block
            }
            signatureNode = XMLUtil.getNextSiblingByName(signatureNode, XML_ELEMENT_NAME);
        }
        if (xmlSignature.m_signatureElements.size() == 0) {
            return null;
        }
        return xmlSignature;
    }

    public void clearCertificates() {
        Enumeration signatures = this.m_signatureElements.elements();
        while (signatures.hasMoreElements()) {
            XMLSignatureElement currentSignature = (XMLSignatureElement)signatures.nextElement();
            currentSignature.clearCertificates();
        }
    }

    public static byte[] toCanonical(Node a_inputNode, Vector a_excludedNodes) throws XMLParseException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (XMLSignature.makeCanonical(a_inputNode, out, false, a_excludedNodes, false, "UTF8") == -1) {
            throw new XMLParseException(a_inputNode.getNodeName(), "Could not make the node canonical!");
        }
        try {
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }

    public static byte[] toCanonicalDeprecated(Node a_inputNode) {
        if (a_inputNode == null || a_inputNode.getPreviousSibling() == null) {
            return null;
        }
        Node parent = a_inputNode.getParentNode();
        parent.removeChild(a_inputNode);
        byte[] dataToVerify = XMLUtil.toByteArray(parent.getOwnerDocument());
        parent.appendChild(a_inputNode);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(out);
        try {
            dataOut.writeShort(dataToVerify.length);
            dataOut.flush();
            out.write(dataToVerify);
            out.flush();
            return out.toByteArray();
        }
        catch (IOException a_e) {
            LogHolder.log(5, LogType.CRYPTO, "Could not make xml data canonical!", a_e);
            return null;
        }
    }

    public static byte[] toCanonical(Node inputNode) throws XMLParseException {
        return XMLSignature.toCanonical(inputNode, false);
    }

    public static byte[] toCanonical(Node inputNode, boolean a_bKeepSpaces) throws XMLParseException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (XMLSignature.makeCanonical(inputNode, out, false, null, a_bKeepSpaces) == -1) {
            throw new XMLParseException(inputNode.getNodeName(), "Could not make the node canonical!");
        }
        try {
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }

    public static String toCanonicalString(Element input) {
        try {
            byte[] canonicalBytes = XMLSignature.toCanonical(input);
            return new String(canonicalBytes);
        }
        catch (Exception e) {
            return "canonicalization error";
        }
    }

    private static int makeCanonical(Node node, OutputStream o, boolean bSiblings, Node excludeNode) {
        return XMLSignature.makeCanonical(node, o, bSiblings, excludeNode, false);
    }

    private static int makeCanonical(Node node, OutputStream o, boolean bSiblings, Node excludeNode, boolean a_bKeepSpaces) {
        return XMLSignature.makeCanonical(node, o, bSiblings, Util.toVector(excludeNode), a_bKeepSpaces, "UTF8");
    }

    private static int makeCanonical(Node node, OutputStream o, boolean bSiblings, Vector excludedNodes, boolean a_bKeepSpaces, String charsetName) {
        try {
            if (node == null) {
                return 0;
            }
            if (node instanceof Document) {
                if (a_bKeepSpaces) {
                    o.write(XMLUtil.createDocumentStructure());
                    o.write(10);
                }
                node = ((Document)node).getDocumentElement();
            }
            if (excludedNodes != null && excludedNodes.contains(node)) {
                return 0;
            }
            if (node.getNodeType() == 1) {
                Node nextSibling;
                Element elem = (Element)node;
                o.write(60);
                if (charsetName != null) {
                    o.write(elem.getNodeName().getBytes(charsetName));
                } else {
                    o.write(elem.getNodeName().getBytes());
                }
                NamedNodeMap attr = elem.getAttributes();
                if (attr.getLength() > 0) {
                    int i;
                    String[] nodeNames = new String[attr.getLength()];
                    String[] nodeValues = new String[attr.getLength()];
                    for (i = 0; i < attr.getLength(); ++i) {
                        nodeNames[i] = attr.item(i).getNodeName();
                        nodeValues[i] = attr.item(i).getNodeValue();
                    }
                    Util.sort(nodeNames, nodeValues);
                    for (i = 0; i < attr.getLength(); ++i) {
                        o.write(32);
                        if (charsetName != null) {
                            o.write(nodeNames[i].getBytes(charsetName));
                        } else {
                            o.write(nodeNames[i].getBytes());
                        }
                        o.write(61);
                        o.write(34);
                        if (charsetName != null) {
                            o.write(nodeValues[i].getBytes(charsetName));
                        } else {
                            o.write(nodeValues[i].getBytes());
                        }
                        o.write(34);
                    }
                }
                o.write(62);
                if (elem.hasChildNodes() && XMLSignature.makeCanonical(elem.getFirstChild(), o, true, excludedNodes, a_bKeepSpaces, charsetName) == -1) {
                    return -1;
                }
                o.write(60);
                o.write(47);
                if (charsetName != null) {
                    o.write(elem.getNodeName().getBytes(charsetName));
                } else {
                    o.write(elem.getNodeName().getBytes());
                }
                o.write(62);
                if (bSiblings && XMLSignature.makeCanonical(nextSibling = XMLUtil.getNextSibling(elem), o, true, excludedNodes, a_bKeepSpaces, charsetName) == -1) {
                    return -1;
                }
            } else {
                if (node.getNodeType() == 3) {
                    String textNode = node.getNodeValue();
                    if (!a_bKeepSpaces) {
                        textNode = textNode.trim();
                    }
                    for (int i = 0; i < XMLUtil.SPECIAL_CHARS.length; ++i) {
                        textNode = Util.replaceAll(textNode, XMLUtil.SPECIAL_CHARS[i], XMLUtil.ENTITIES[i], (String[])(XMLUtil.SPECIAL_CHARS[i].equals("&") ? XMLUtil.ENTITIES : null));
                    }
                    if (charsetName != null) {
                        o.write(textNode.getBytes(charsetName));
                    } else {
                        o.write(textNode.getBytes());
                    }
                    if (XMLSignature.makeCanonical(XMLUtil.getNextSibling(node), o, true, excludedNodes, a_bKeepSpaces, charsetName) == -1) {
                        return -1;
                    }
                    return 0;
                }
                if (node.getNodeType() == 8) {
                    if (a_bKeepSpaces) {
                        if (charsetName != null) {
                            o.write("<!--".getBytes(charsetName));
                            o.write(node.getNodeValue().getBytes(charsetName));
                            o.write("-->\n".getBytes(charsetName));
                        } else {
                            o.write("<!--".getBytes());
                            o.write(node.getNodeValue().getBytes());
                            o.write("-->\n".getBytes());
                        }
                    }
                    if (XMLSignature.makeCanonical(XMLUtil.getNextSibling(node), o, true, excludedNodes, a_bKeepSpaces, charsetName) == -1) {
                        return -1;
                    }
                    return 0;
                }
                return -1;
            }
            return 0;
        }
        catch (Throwable e) {
            LogHolder.log(2, LogType.MISC, "Error while making canonical XML", e);
            return -1;
        }
    }

    public Element[] getXMLElements(Document a_doc) {
        int i;
        Vector<Element> vecElements = new Vector<Element>();
        for (i = 0; i < this.m_signatureElements.size(); ++i) {
            Element curElement = ((XMLSignatureElement)this.m_signatureElements.elementAt(i)).toXmlElement(a_doc);
            if (curElement == null) continue;
            vecElements.addElement(curElement);
        }
        Element[] elements = new Element[vecElements.size()];
        for (i = 0; i < vecElements.size(); ++i) {
            elements[i] = (Element)vecElements.elementAt(i);
        }
        return elements;
    }
}

