/*
 * Decompiled with CFR 0.152.
 */
package anon.mixminion.message;

import anon.mixminion.fec.FECCode;
import anon.mixminion.fec.FECCodeFactory;
import anon.mixminion.message.Message;
import anon.util.ByteArrayUtil;

public class FragmentContainer {
    private byte[] m_id = null;
    private int FRAGSIZE = Message.BLOCK_SIZE - 47;
    private byte[][] m_fragments;
    private boolean m_readytoreassemble = false;
    private int m_counter;
    private int[] m_indizes;
    private int m_numberoffrags;
    private boolean[] m_add;

    public FragmentContainer(byte[] id, int numberoffrags) {
        this.m_id = id;
        this.m_numberoffrags = numberoffrags;
        this.m_fragments = new byte[numberoffrags][this.FRAGSIZE];
        this.m_counter = numberoffrags - 1;
        this.m_indizes = new int[numberoffrags];
        double tmp = Math.log(this.m_numberoffrags) / Math.log(2.0);
        tmp = Math.ceil(tmp);
        tmp = Math.pow(2.0, tmp);
        int k = (int)Math.min(16.0, tmp);
        int n = (int)Math.ceil(Message.EXP_FACTOR * (double)k);
        this.m_add = new boolean[n];
    }

    public boolean addFragment(byte[] frag, int index) {
        if (this.m_readytoreassemble) {
            return true;
        }
        if (!this.m_add[index]) {
            this.m_add[index] = true;
            this.m_indizes[this.m_counter] = index;
            this.m_fragments[this.m_counter] = frag;
            --this.m_counter;
        }
        if (this.m_counter == -1) {
            this.m_readytoreassemble = true;
            return true;
        }
        return false;
    }

    public byte[] getID() {
        return this.m_id;
    }

    public byte[] reassembleMessage() {
        byte[] message = null;
        if (this.m_readytoreassemble) {
            message = new byte[]{};
            double tmp = Math.log(this.m_numberoffrags) / Math.log(2.0);
            tmp = Math.ceil(tmp);
            tmp = Math.pow(2.0, tmp);
            int k = (int)Math.min(16.0, tmp);
            int n = (int)Math.ceil(Message.EXP_FACTOR * (double)k);
            FECCode fec = FECCodeFactory.getDefault().createFECCode(k, n);
            int[] offsets = new int[this.m_numberoffrags];
            fec.decode(this.m_fragments, offsets, this.m_indizes, this.FRAGSIZE, false);
            for (int i = 0; i < k; ++i) {
                message = ByteArrayUtil.conc(message, this.m_fragments[i]);
            }
            return message;
        }
        return message;
    }
}

