/*
 * Decompiled with CFR 0.152.
 */
package anon.shared;

import anon.shared.AbstractAnonChannel;
import anon.shared.IOQueue;
import java.io.IOException;
import java.io.InputStream;

final class ChannelInputStream
extends InputStream {
    private IOQueue m_Queue = new IOQueue();
    private boolean m_bIsClosed = false;

    ChannelInputStream(AbstractAnonChannel c) {
    }

    protected void recv(byte[] buff, int pos, int len) throws IOException {
        try {
            this.m_Queue.write(buff, pos, len);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public synchronized int available() throws IOException {
        return this.m_Queue.available();
    }

    public int read() throws IOException {
        return this.m_Queue.read();
    }

    public int read(byte[] out) throws IOException {
        return this.m_Queue.read(out, 0, out.length);
    }

    public int read(byte[] out, int pos, int len) throws IOException {
        return this.m_Queue.read(out, pos, len);
    }

    protected void closedByPeer() {
        try {
            this.m_Queue.closeWrite();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void close() throws IOException {
        if (!this.m_bIsClosed) {
            try {
                this.m_Queue.closeWrite();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_Queue.closeRead();
            this.m_Queue = null;
            this.m_bIsClosed = true;
        }
    }
}

