/*
 * Decompiled with CFR 0.152.
 */
package jarify;

import jarify.JarManifest;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class JarSignatureFile
extends JarManifest {
    private Hashtable manifestdigests = new Hashtable();

    public JarSignatureFile(String name, long size, InputStream stream) {
        super(size, stream);
        this.name = name;
        this.parseManifestDigests();
    }

    private void parseManifestDigests() {
        int contPos;
        String header = this.contentStrRaw.substring(0, this.contentStrRaw.indexOf(this.newLine + "Name: "));
        while ((contPos = header.indexOf(this.newLine + " ")) != -1) {
            header = header.substring(0, contPos) + header.substring(contPos + this.newLine.length() + 1, header.length());
        }
        int startPos = 0;
        int endPos = 0;
        Vector<String> tmpVector = new Vector<String>();
        while ((endPos = header.indexOf(this.newLine, startPos)) != -1) {
            tmpVector.addElement(header.substring(startPos, endPos));
            startPos = endPos + this.newLine.length();
        }
        for (int i = 0; i < tmpVector.size(); ++i) {
            String line = (String)tmpVector.elementAt(i);
            startPos = line.indexOf("-Manifest: ");
            if (startPos == -1) continue;
            String digName = line.substring(0, startPos);
            String value = line.substring(startPos + 11);
            this.manifestdigests.put(digName, value);
        }
    }

    public String getManifestDigest(String digestID) {
        return (String)this.manifestdigests.get(digestID);
    }

    public Vector getManifestDigestList() {
        Enumeration digs = this.manifestdigests.keys();
        Vector digVector = new Vector();
        while (digs.hasMoreElements()) {
            digVector.addElement(digs.nextElement());
        }
        return digVector;
    }

    public String getAlias() {
        if (this.name.indexOf(".") == -1) {
            return null;
        }
        return this.name.substring(this.name.lastIndexOf("/") + 1, this.name.lastIndexOf("."));
    }
}

