/*
 * Decompiled with CFR 0.152.
 */
package anon.client.replay;

import anon.client.MixParameters;
import anon.client.replay.ReplayControlChannel;
import anon.client.replay.ReplayTimestamp;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class TimestampUpdater
implements Observer {
    private MixParameters[] m_mixParameters;
    private boolean m_responseReceived;
    private Object m_internalSynchronization;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimestampUpdater(MixParameters[] a_mixParameters, ReplayControlChannel a_controlChannel) throws Exception {
        this.m_mixParameters = a_mixParameters;
        this.m_responseReceived = false;
        Object object = this.m_internalSynchronization = new Object();
        synchronized (object) {
            a_controlChannel.getMessageDistributor().addObserver(this);
            a_controlChannel.requestTimestamps();
            while (!this.m_responseReceived) {
                this.m_internalSynchronization.wait();
            }
        }
        for (int i = 0; i < this.m_mixParameters.length; ++i) {
            if (this.m_mixParameters[i].getReplayTimestamp() != null) continue;
            throw new Exception("TimestampUpdater: Constructor: Timestamp of Mix '" + this.m_mixParameters[i].getMixId() + "' is missing.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Observable a_object, Object a_argument) {
        if (a_argument instanceof Vector) {
            LogHolder.log(7, LogType.NET, "TimestampUpdater: update(): Received some timestamps.");
            Enumeration timestamps = ((Vector)a_argument).elements();
            Vector<Integer> updatedMixes = new Vector<Integer>();
            while (timestamps.hasMoreElements()) {
                ReplayTimestamp currentTimestamp = (ReplayTimestamp)timestamps.nextElement();
                boolean mixFound = false;
                for (int i = 0; i < this.m_mixParameters.length && !mixFound; ++i) {
                    if (!this.m_mixParameters[i].getMixId().equals(currentTimestamp.getMixId())) continue;
                    this.m_mixParameters[i].setReplayTimestamp(currentTimestamp);
                    mixFound = true;
                    if (updatedMixes.contains(new Integer(i))) {
                        LogHolder.log(6, LogType.NET, "TimestampUpdater: update(): Received timestamp for Mix '" + currentTimestamp.getMixId() + "' twice.");
                        continue;
                    }
                    updatedMixes.addElement(new Integer(i));
                }
                if (mixFound) continue;
                LogHolder.log(6, LogType.NET, "TimestampUpdater: update(): Received timestamp of Mix '" + currentTimestamp.getMixId() + "' is not necessary for the current cascade.");
            }
            for (int i = 0; i < this.m_mixParameters.length; ++i) {
                if (updatedMixes.contains(new Integer(i))) continue;
                LogHolder.log(3, LogType.NET, "TimestampUpdater: update(): Timestamp of Mix '" + this.m_mixParameters[i].getMixId() + "' is missing.");
            }
            Object object = this.m_internalSynchronization;
            synchronized (object) {
                this.m_responseReceived = true;
                this.m_internalSynchronization.notifyAll();
            }
        }
        if (a_argument instanceof Exception) {
            LogHolder.log(3, LogType.NET, "TimestampUpdater: update(): Received exception: " + a_argument.toString());
            Object object = this.m_internalSynchronization;
            synchronized (object) {
                this.m_responseReceived = true;
                this.m_internalSynchronization.notifyAll();
            }
        }
    }
}

