/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AbstractX509AlternativeName;
import anon.crypto.AbstractX509Extension;
import anon.crypto.AsymmetricCryptoKeyPair;
import anon.crypto.ByteSignature;
import anon.crypto.DSAKeyPair;
import anon.crypto.ICertificate;
import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.MyX509Extensions;
import anon.crypto.PKCS12;
import anon.crypto.RevokedCertifcateStore;
import anon.crypto.Validity;
import anon.crypto.X509DistinguishedName;
import anon.crypto.X509SubjectAlternativeName;
import anon.crypto.X509SubjectKeyIdentifier;
import anon.util.Base64;
import anon.util.IResourceInstantiator;
import anon.util.IXMLEncodable;
import anon.util.ResourceLoader;
import anon.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import logging.LogHolder;
import logging.LogType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SkeinDigest;
import org.bouncycastle.util.encoders.Hex;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class JAPCertificate
implements IXMLEncodable,
Cloneable,
ICertificate {
    public static final int CERTIFICATE_TYPE_ROOT_MIX = 1;
    public static final int CERTIFICATE_TYPE_ROOT_INFOSERVICE = 5;
    public static final int CERTIFICATE_TYPE_ROOT_UPDATE = 6;
    public static final int CERTIFICATE_TYPE_ROOT_PAYMENT = 8;
    public static final int CERTIFICATE_TYPE_MIX = 2;
    public static final int CERTIFICATE_TYPE_INFOSERVICE = 3;
    public static final int CERTIFICATE_TYPE_UPDATE = 4;
    public static final int CERTIFICATE_TYPE_PAYMENT = 7;
    public static final int CERTIFICATE_TYPE_TERMS_AND_CONDITIONS = 9;
    public static final int CERTIFICATE_TYPE_ROOT_TERMS_AND_CONDITIONS = 10;
    public static final int CERTIFICATE_TYPE_ROOT = 0;
    public static final String XML_ELEMENT_NAME = "X509Certificate";
    public static final String XML_ELEMENT_CONTAINER_NAME = "X509Data";
    private static final String BASE64_TAG = "CERTIFICATE";
    private static final String BASE64_ALTERNATIVE_TAG = "X509 CERTIFICATE";
    private static final String IDENTIFIER_DSA_WITH_SHA1 = "1.2.840.10040.4.3";
    private static final String DSA_WITH_SHA1 = "dsaWithSHA1";
    private static final String IDENTIFIER_MD2_WITH_RSA_ENCRYPTION = "1.2.840.113549.1.1.2";
    private static final String MD2_WITH_RSA_ENCRYPTION = "md2WithRSAEncryption";
    private static final String IDENTIFIER_MD5_WITH_RSA_ENCRYPTION = "1.2.840.113549.1.1.4";
    private static final String MD5_WITH_RSA_ENCRYPTION = "md5WithRSAEncryption";
    private static final String IDENTIFIER_SHA1_WITH_RSA_ENCRYPTION = "1.2.840.113549.1.1.5";
    private static final String SHA1_WITH_RSA_ENCRYPTION = "sha-1WithRSAEncryption";
    private static final String IDENTIFIER_ECDSA_WITH_SHA1 = "1.2.840.10045.4.1";
    private static final String ECDSA_WITH_SHA1 = "ecdsa-with-SHA1";
    private static IMyPrivateKey ms_dummyPrivateKey;
    private Certificate m_bcCertificate;
    private X509DistinguishedName m_subject;
    private X509DistinguishedName m_issuer;
    private MyX509Extensions m_extensions;
    private X509SubjectKeyIdentifier m_subjectKeyIdentifier;
    private IMyPublicKey m_PubKey;
    private String m_id;
    private String m_sha1Fingerprint;
    private String m_md5Fingerprint;
    private String m_skeinFingerprint;
    private Validity m_validity;

    private JAPCertificate(Certificate x509cert) throws IllegalArgumentException {
        DERTaggedObject dto = new DERTaggedObject(true, 3, x509cert);
        ASN1Sequence asn1seq = ASN1Sequence.getInstance(dto, true);
        this.m_bcCertificate = Certificate.getInstance(asn1seq);
        ASN1ObjectIdentifier id = x509cert.getSignatureAlgorithm().getAlgorithm();
        try {
            this.m_PubKey = AsymmetricCryptoKeyPair.createPublicKey(x509cert.getSubjectPublicKeyInfo());
        }
        catch (Exception a_e) {
            LogHolder.log(2, LogType.MISC, a_e);
            throw new IllegalArgumentException("Certificate structure contains invalid public key! " + a_e);
        }
        byte[] data = this.toByteArray();
        this.m_sha1Fingerprint = JAPCertificate.createFingerprint(new SHA1Digest(), data);
        this.m_md5Fingerprint = JAPCertificate.createFingerprint(new MD5Digest(), data);
        this.m_skeinFingerprint = JAPCertificate.createFingerprint(new SkeinDigest(256, 128), data);
        Calendar startDate = Calendar.getInstance();
        startDate.setTime(this.m_bcCertificate.getStartDate().getDate());
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(this.m_bcCertificate.getEndDate().getDate());
        this.m_validity = new Validity(startDate, endDate);
        this.m_subject = new X509DistinguishedName(this.m_bcCertificate.getSubject());
        this.m_issuer = new X509DistinguishedName(this.m_bcCertificate.getIssuer());
        this.m_extensions = new MyX509Extensions(this.m_bcCertificate.getTBSCertificate().getExtensions());
        this.m_id = this.m_sha1Fingerprint + this.m_validity.getValidFrom() + this.m_validity.getValidTo();
        this.m_subjectKeyIdentifier = (X509SubjectKeyIdentifier)this.m_extensions.getExtension(X509SubjectKeyIdentifier.IDENTIFIER);
        if (this.m_subjectKeyIdentifier == null) {
            this.m_subjectKeyIdentifier = new X509SubjectKeyIdentifier(this.getPublicKey());
        }
    }

    public static JAPCertificate getInstance(Certificate x509cert) {
        JAPCertificate certificate;
        try {
            certificate = new JAPCertificate(x509cert);
        }
        catch (IllegalArgumentException a_e) {
            return null;
        }
        return certificate;
    }

    public static JAPCertificate getInstance(JAPCertificate x509cert) {
        if (x509cert == null) {
            return null;
        }
        return JAPCertificate.getInstance(x509cert.m_bcCertificate);
    }

    public static JAPCertificate getInstance(byte[] a_certificate) {
        if (a_certificate == null || a_certificate.length == 0) {
            return null;
        }
        try {
            ASN1Sequence certificate = JAPCertificate.toASN1Sequence(a_certificate, XML_ELEMENT_NAME);
            if (certificate.size() > 1 && certificate.getObjectAt(1) instanceof ASN1ObjectIdentifier && certificate.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
                return JAPCertificate.getInstance(Certificate.getInstance(new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)certificate.getObjectAt(1), true)).getCertificates().getObjectAt(0)));
            }
            Certificate x509certstruct = Certificate.getInstance(certificate);
            return JAPCertificate.getInstance(x509certstruct);
        }
        catch (Exception a_e) {
            return null;
        }
    }

    public static Hashtable getInstance(String a_strResourceSearchPath, boolean a_bRecursive, String a_strIgnoreCertMark) {
        try {
            return ResourceLoader.loadResources(a_strResourceSearchPath, new X509CertificateInstantiator(a_strIgnoreCertMark), a_bRecursive);
        }
        catch (Exception a_e) {
            LogHolder.log(3, LogType.MISC, a_e);
            return new Hashtable();
        }
    }

    public static Hashtable getInstance(String a_strResourceSearchPath, boolean a_bRecursive) {
        return JAPCertificate.getInstance(a_strResourceSearchPath, a_bRecursive, null);
    }

    public static JAPCertificate getInstance(InputStream a_in) {
        byte[] bytes;
        try {
            bytes = ResourceLoader.getStreamAsBytes(a_in);
        }
        catch (IOException a_e) {
            return null;
        }
        return JAPCertificate.getInstance(bytes);
    }

    public static JAPCertificate getInstance(Node a_NodeRoot) {
        try {
            if (!a_NodeRoot.getNodeName().equals(XML_ELEMENT_NAME)) {
                return null;
            }
            Element elemX509Cert = (Element)a_NodeRoot;
            String strValue = XMLUtil.parseValue((Node)elemX509Cert, (String)null);
            byte[] bytecert = Base64.decode(strValue);
            return JAPCertificate.getInstance(bytecert);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static JAPCertificate getInstance(File a_file) {
        if (a_file == null) {
            return null;
        }
        byte[] buff = null;
        try {
            buff = new byte[(int)a_file.length()];
            FileInputStream fin = new FileInputStream(a_file);
            fin.read(buff);
            fin.close();
        }
        catch (Exception e) {
            return null;
        }
        return JAPCertificate.getInstance(buff);
    }

    public static JAPCertificate getInstance(String a_certString) {
        try {
            return JAPCertificate.getInstance(a_certString.getBytes());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final JAPCertificate getInstance(IMyPublicKey a_publicKey, Calendar a_validFrom) {
        return JAPCertificate.getInstance(new X509DistinguishedName("CN=void"), new X509DistinguishedName("CN=void"), JAPCertificate.getDummyPrivateKey(), a_publicKey, new Validity(a_validFrom, -1), null, new BigInteger("1"));
    }

    public static JAPCertificate getInstance(X509DistinguishedName a_ownerAlias, AsymmetricCryptoKeyPair a_keyPair, Validity a_validity) {
        return JAPCertificate.getInstance(a_ownerAlias, a_keyPair, a_validity, null);
    }

    public static JAPCertificate getInstance(X509DistinguishedName a_ownerAlias, AsymmetricCryptoKeyPair a_keyPair, Validity a_validity, MyX509Extensions a_extensions) {
        return JAPCertificate.getInstance(a_ownerAlias, a_ownerAlias, a_keyPair.getPrivate(), a_keyPair.getPublic(), a_validity, a_extensions, new BigInteger("1"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String calculateXORofSKIs(Vector a_certificates) {
        String strXoredID;
        if (a_certificates == null) {
            return null;
        }
        Vector vector = a_certificates;
        synchronized (vector) {
            if (a_certificates.size() == 0) {
                return null;
            }
            byte[] raw = new byte[20];
            Enumeration enumCertificates = a_certificates.elements();
            while (enumCertificates.hasMoreElements()) {
                byte[] ski = ((JAPCertificate)enumCertificates.nextElement()).getRawSubjectKeyIdentifier();
                if (ski == null) continue;
                for (int j = 0; j < raw.length; ++j) {
                    raw[j] = (byte)(raw[j] ^ ski[j]);
                }
            }
            strXoredID = new String(Hex.encode(raw));
        }
        return strXoredID.toUpperCase();
    }

    public boolean equals(Object a_certificate) {
        if (this == a_certificate) {
            return true;
        }
        if (a_certificate == null || !(a_certificate instanceof JAPCertificate)) {
            return false;
        }
        return this.getId().equals(((JAPCertificate)a_certificate).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public Object clone() {
        return JAPCertificate.getInstance(this.m_bcCertificate);
    }

    public String getId() {
        return this.m_id;
    }

    public IMyPublicKey getPublicKey() {
        return this.m_PubKey;
    }

    public MyX509Extensions getExtensions() {
        return this.m_extensions;
    }

    public String getSubjectKeyIdentifier() {
        return this.m_subjectKeyIdentifier.getValue();
    }

    public String getSubjectKeyIdentifierConcatenated() {
        return this.m_subjectKeyIdentifier.getValueWithoutColon();
    }

    public byte[] getRawSubjectKeyIdentifier() {
        String ski = this.m_subjectKeyIdentifier.getValueWithoutColon();
        if (ski == null) {
            return null;
        }
        return Hex.decode(ski);
    }

    public String getSignatureAlgorithmName() {
        String id = this.m_bcCertificate.getSignatureAlgorithm().getAlgorithm().getId();
        if (id.equals(IDENTIFIER_DSA_WITH_SHA1)) {
            return DSA_WITH_SHA1;
        }
        if (id.equals(IDENTIFIER_SHA1_WITH_RSA_ENCRYPTION)) {
            return SHA1_WITH_RSA_ENCRYPTION;
        }
        if (id.equals(IDENTIFIER_MD5_WITH_RSA_ENCRYPTION)) {
            return MD5_WITH_RSA_ENCRYPTION;
        }
        if (id.equals(IDENTIFIER_MD2_WITH_RSA_ENCRYPTION)) {
            return MD2_WITH_RSA_ENCRYPTION;
        }
        if (id.equals(IDENTIFIER_ECDSA_WITH_SHA1)) {
            return ECDSA_WITH_SHA1;
        }
        return id;
    }

    public BigInteger getSerialNumber() {
        return this.m_bcCertificate.getSerialNumber().getPositiveValue();
    }

    public X509DistinguishedName getIssuer() {
        return this.m_issuer;
    }

    public X509DistinguishedName getSubject() {
        return this.m_subject;
    }

    public String getAnyEmailAddress() {
        try {
            X509DistinguishedName disName = this.getSubject();
            String emailAddress = disName.getE_EmailAddress();
            if (emailAddress != null) {
                return emailAddress;
            }
            emailAddress = disName.getEmailAddress();
            if (emailAddress != null) {
                return emailAddress;
            }
            MyX509Extensions allExtensions = this.getExtensions();
            Vector allExtensionsVector = allExtensions.getExtensions();
            for (int idx = 0; idx < allExtensionsVector.size(); ++idx) {
                AbstractX509Extension curExt = (AbstractX509Extension)allExtensionsVector.elementAt(idx);
                if (!(curExt instanceof X509SubjectAlternativeName)) continue;
                X509SubjectAlternativeName name = (X509SubjectAlternativeName)curExt;
                Vector tags = name.getTags();
                for (int i = 0; i < tags.size(); ++i) {
                    Integer tag = (Integer)tags.elementAt(i);
                    if (!tag.equals(AbstractX509AlternativeName.TAG_EMAIL) || (emailAddress = (String)name.getValues().elementAt(tag)) == null) continue;
                    return emailAddress;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public JAPCertificate getX509Certificate() {
        return this;
    }

    public String getSHA1Fingerprint() {
        return this.m_sha1Fingerprint;
    }

    public String getMD5Fingerprint() {
        return this.m_md5Fingerprint;
    }

    public String getSKEINFingerprint() {
        return this.m_skeinFingerprint;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            new DEROutputStream(out).writeObject(this.m_bcCertificate);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }

    public byte[] toByteArray(boolean a_Base64Encoded) {
        if (a_Base64Encoded) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                out.write(Base64.createBeginTag(BASE64_TAG).getBytes());
                out.write(Base64.encode(this.toByteArray(), true).getBytes());
                out.write(Base64.createEndTag(BASE64_TAG).getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return out.toByteArray();
        }
        return this.toByteArray();
    }

    public void store(OutputStream a_ostream) throws IOException {
        DEROutputStream derOutputStream = new DEROutputStream(a_ostream);
        derOutputStream.writeObject(this.m_bcCertificate);
    }

    public void store(OutputStream a_ostream, boolean a_bBase64Encoded) throws IOException {
        a_ostream.write(this.toByteArray(a_bBase64Encoded));
    }

    public Validity getValidity() {
        return this.m_validity;
    }

    public synchronized boolean verify(Vector a_verifyingCertificates) {
        return this.verify(a_verifyingCertificates.elements());
    }

    public synchronized boolean verify(Hashtable a_verifyingCertificates) {
        return this.verify(a_verifyingCertificates.elements());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean verify(Enumeration a_verifyingCertificates) {
        if (a_verifyingCertificates == null) {
            return false;
        }
        Enumeration enumeration = a_verifyingCertificates;
        synchronized (enumeration) {
            while (a_verifyingCertificates.hasMoreElements()) {
                JAPCertificate currentCertificate = (JAPCertificate)a_verifyingCertificates.nextElement();
                if (!this.verify(currentCertificate)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean verify(JAPCertificate a_certificate) {
        if (a_certificate == null) {
            return false;
        }
        return this.verify(a_certificate.getPublicKey());
    }

    public synchronized boolean verify(IMyPublicKey a_publicKey) {
        if (a_publicKey == null) {
            return false;
        }
        AlgorithmIdentifier aid1 = a_publicKey.getSignatureAlgorithm().getIdentifier();
        AlgorithmIdentifier aid2 = this.m_bcCertificate.getSignatureAlgorithm();
        if (aid1.getAlgorithm().equals(aid2.getAlgorithm())) {
            try {
                ByteArrayOutputStream bArrOStream = new ByteArrayOutputStream();
                new DEROutputStream(bArrOStream).writeObject(this.m_bcCertificate.getTBSCertificate());
                return ByteSignature.verify(bArrOStream.toByteArray(), this.m_bcCertificate.getSignature().getBytes(), a_publicKey);
            }
            catch (IOException a_e) {
                // empty catch block
            }
        }
        return false;
    }

    public JAPCertificate sign(PKCS12 a_signerCertificate) {
        X509CertificateGenerator certgen = new X509CertificateGenerator(this.m_bcCertificate.getTBSCertificate());
        Certificate x509cert = certgen.sign(a_signerCertificate);
        JAPCertificate certificate = JAPCertificate.getInstance(x509cert);
        return certificate;
    }

    public JAPCertificate sign(PKCS12 a_signerCertificate, Validity a_validity, MyX509Extensions a_extensions, BigInteger a_serialNumber) {
        return JAPCertificate.getInstance(new X509DistinguishedName(this.m_bcCertificate.getSubject()), a_signerCertificate.getSubject(), a_signerCertificate.getPrivateKey(), this.getPublicKey(), a_validity, a_extensions, a_serialNumber);
    }

    public static JAPCertificate getInstance(X509DistinguishedName a_ownerAlias, X509DistinguishedName a_issuer, IMyPrivateKey a_privateKey, IMyPublicKey a_publicKey, Validity a_validity, MyX509Extensions a_extensions, BigInteger a_serialNumber) {
        X509CertificateGenerator v3CertGen = null;
        v3CertGen = new X509CertificateGenerator(a_ownerAlias, a_validity.getValidFrom(), a_validity.getValidTo(), a_publicKey, a_extensions, a_serialNumber);
        Certificate certStruct = v3CertGen.sign(a_issuer.getX500Name(), a_privateKey);
        JAPCertificate cert = JAPCertificate.getInstance(certStruct);
        return cert;
    }

    public Element toXmlElement(Document a_doc) {
        Element elemX509Cert = a_doc.createElement(XML_ELEMENT_NAME);
        elemX509Cert.setAttribute("xml:space", "preserve");
        XMLUtil.setValue((Node)elemX509Cert, Base64.encode(this.toByteArray(), true));
        return elemX509Cert;
    }

    ASN1Encodable getBouncyCastleCertificate() {
        return this.m_bcCertificate;
    }

    SubjectPublicKeyInfo getBouncyCastleSubjectPublicKeyInfo() {
        return this.m_bcCertificate.getSubjectPublicKeyInfo();
    }

    static ASN1Sequence toASN1Sequence(byte[] a_bytes, String a_xmlElementName) {
        ByteArrayInputStream bin = null;
        if (a_bytes == null || a_bytes.length == 0) {
            return null;
        }
        try {
            if (a_bytes[0] != 48) {
                String line;
                String certString = new String(a_bytes);
                StringTokenizer tokenizer = new StringTokenizer(certString);
                StringBuffer sbuf = new StringBuffer();
                boolean endTagFound = false;
                if (a_xmlElementName != null && (a_xmlElementName.trim().length() == 0 || new StringTokenizer(a_xmlElementName).countTokens() > 1)) {
                    a_xmlElementName = null;
                }
                block2: while (tokenizer.hasMoreTokens()) {
                    int endTagIndex;
                    int tagIndex;
                    line = tokenizer.nextToken();
                    if (line.startsWith("-----BEGIN ".trim())) {
                        while (!line.endsWith("-----")) {
                            if (tokenizer.hasMoreTokens() && (line = tokenizer.nextToken()) != null) continue;
                            continue block2;
                        }
                        break;
                    }
                    if (a_xmlElementName == null || (tagIndex = line.indexOf("<" + a_xmlElementName)) < 0 || tagIndex >= (endTagIndex = certString.indexOf(">"))) continue;
                    tagIndex = endTagIndex + 1;
                    endTagIndex = certString.indexOf("</" + a_xmlElementName + ">");
                    if (endTagIndex < 0) continue;
                    endTagFound = true;
                    sbuf.append(certString.substring(certString.indexOf(">") + 1, endTagIndex));
                    break;
                }
                if (!endTagFound) {
                    if (!tokenizer.hasMoreTokens()) {
                        throw new Exception();
                    }
                    block4: while (tokenizer.hasMoreTokens()) {
                        line = tokenizer.nextToken();
                        if (line.startsWith("-----END ".trim())) {
                            do {
                                if (!line.endsWith("-----")) continue;
                                endTagFound = true;
                                break block4;
                            } while (tokenizer.hasMoreTokens() && (line = tokenizer.nextToken()) != null);
                        }
                        sbuf.append(line);
                    }
                }
                if (!endTagFound) {
                    throw new Exception();
                }
                bin = new ByteArrayInputStream(Base64.decode(sbuf.toString()));
            }
            if (bin == null && a_bytes[1] == 128) {
                ASN1InputStream in = new ASN1InputStream(new ByteArrayInputStream(a_bytes));
                return (ASN1Sequence)in.readObject();
            }
            if (bin == null) {
                bin = new ByteArrayInputStream(a_bytes);
            }
            return (ASN1Sequence)new ASN1InputStream(bin).readObject();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Byte array is no valid ASN1 sequence data!");
        }
    }

    protected static String createFingerprint(Digest a_digestGenerator, byte[] a_data) {
        byte[] digestData = new byte[a_digestGenerator.getDigestSize()];
        a_digestGenerator.update(a_data, 0, a_data.length);
        a_digestGenerator.doFinal(digestData, 0);
        return ByteSignature.toHexString(digestData);
    }

    private static IMyPrivateKey getDummyPrivateKey() {
        if (ms_dummyPrivateKey == null) {
            SecureRandom random = new SecureRandom();
            random.setSeed(58921787L);
            ms_dummyPrivateKey = DSAKeyPair.getInstance(random, 256, 100).getPrivate();
        }
        return ms_dummyPrivateKey;
    }

    public boolean isSelfSigned() {
        return this.verify(this.getPublicKey());
    }

    public boolean isRevoked() {
        return RevokedCertifcateStore.getInstance().isCertificateRevoked(this);
    }

    private static final class X509CertificateInstantiator
    implements IResourceInstantiator {
        private String m_strIgnoreCertMark;

        public X509CertificateInstantiator(String a_strIgnoreCertMark) {
            this.m_strIgnoreCertMark = a_strIgnoreCertMark;
        }

        public Object getInstance(File a_file, File a_topDirectory) throws IOException {
            if (a_file == null || this.isBlocked(a_file.getName())) {
                return null;
            }
            JAPCertificate cert = null;
            FileInputStream fIn = new FileInputStream(a_file);
            try {
                cert = JAPCertificate.getInstance(fIn);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                fIn.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            return cert;
        }

        public Object getInstance(ZipEntry a_entry, ZipFile a_file) throws IOException {
            if (a_file == null || this.isBlocked(a_entry.getName())) {
                return null;
            }
            return JAPCertificate.getInstance(a_file.getInputStream(a_entry));
        }

        public Object getInstance(InputStream a_inputStream, String a_resourceName) {
            if (a_resourceName == null || this.isBlocked(a_resourceName)) {
                return null;
            }
            return JAPCertificate.getInstance(a_inputStream);
        }

        private boolean isBlocked(String a_resourceName) {
            if (this.m_strIgnoreCertMark == null || a_resourceName == null || this.m_strIgnoreCertMark.trim().length() == 0) {
                return false;
            }
            if (a_resourceName.endsWith(this.m_strIgnoreCertMark)) {
                return true;
            }
            int index = a_resourceName.indexOf(this.m_strIgnoreCertMark);
            return index >= 0 && (a_resourceName = a_resourceName.substring(index, a_resourceName.length())).indexOf("/") < 0 && a_resourceName.indexOf(File.separator) < 0;
        }
    }

    private static final class X509CertificateGenerator
    extends V3TBSCertificateGenerator {
        public X509CertificateGenerator(X509DistinguishedName a_ownerAlias, Date a_validFrom, Date a_validTo, IMyPublicKey a_publicKey, MyX509Extensions a_extensions, BigInteger a_serialNumber) {
            this.setStartDate(new DERUTCTime(a_validFrom));
            this.setEndDate(new DERUTCTime(a_validTo));
            if (a_serialNumber == null) {
                this.setSerialNumber(new ASN1Integer(1L));
            } else {
                this.setSerialNumber(new ASN1Integer(a_serialNumber));
            }
            this.setSubject(a_ownerAlias.getX500Name());
            this.setSubjectPublicKeyInfo(a_publicKey.getAsSubjectPublicKeyInfo());
            if (a_extensions != null && a_extensions.getSize() > 0) {
                this.setExtensions(a_extensions.getExtensionsAsBCExtensions());
            } else {
                this.setExtensions(new MyX509Extensions(new Vector()).getExtensionsAsBCExtensions());
            }
        }

        public X509CertificateGenerator(TBSCertificate tbsCertificate) {
            this.setStartDate(tbsCertificate.getStartDate());
            this.setEndDate(tbsCertificate.getEndDate());
            this.setSerialNumber(tbsCertificate.getSerialNumber());
            this.setSubject(tbsCertificate.getSubject());
            this.setSubjectPublicKeyInfo(tbsCertificate.getSubjectPublicKeyInfo());
            this.setExtensions(tbsCertificate.getExtensions());
            this.setIssuer(tbsCertificate.getIssuer());
            this.setSignature(tbsCertificate.getSignature());
        }

        public Certificate sign(PKCS12 a_pkcs12Certificate) {
            return this.sign(a_pkcs12Certificate.getX509Certificate().m_bcCertificate.getSubject(), a_pkcs12Certificate.getPrivateKey());
        }

        public Certificate sign(X500Name a_issuer, IMyPrivateKey a_privateKey) {
            return this.sign_internal(a_issuer, a_privateKey);
        }

        private Certificate sign_internal(X500Name a_issuer, IMyPrivateKey a_privateKey) {
            try {
                this.setIssuer(a_issuer);
                this.setSignature(a_privateKey.getSignatureAlgorithm().getIdentifier());
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                TBSCertificate tbsCert = this.generateTBSCertificate();
                new DEROutputStream(bOut).writeObject(tbsCert);
                byte[] signature = ByteSignature.sign(bOut.toByteArray(), a_privateKey);
                ASN1EncodableVector seqv = new ASN1EncodableVector();
                seqv.add(tbsCert);
                seqv.add(a_privateKey.getSignatureAlgorithm().getIdentifier());
                seqv.add(new DERBitString(signature));
                return Certificate.getInstance(new DERSequence(seqv));
            }
            catch (Throwable t) {
                LogHolder.log(2, LogType.MISC, t);
                return null;
            }
        }
    }
}

