/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.JAPCertificate;
import anon.crypto.MyX509Extensions;
import anon.crypto.X509CertificateIssuer;
import anon.crypto.X509DistinguishedName;
import java.math.BigInteger;
import java.util.Date;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class RevokedCertificate {
    public static final Class[] CRL_ENTRY_EXTENSIONS = new Class[]{class$anon$crypto$X509CertificateIssuer == null ? (class$anon$crypto$X509CertificateIssuer = RevokedCertificate.class$("anon.crypto.X509CertificateIssuer")) : class$anon$crypto$X509CertificateIssuer};
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private static BigInteger ONE = BigInteger.valueOf(1L);
    private BigInteger m_serial;
    private Date m_revocationDate;
    private MyX509Extensions m_extensions;
    static /* synthetic */ Class class$anon$crypto$X509CertificateIssuer;

    public RevokedCertificate(JAPCertificate a_cert, Date a_revocationDate, MyX509Extensions a_extensions) {
        this.m_revocationDate = a_revocationDate;
        this.m_serial = RevokedCertificate.getUniqueSerial(a_cert);
        this.m_extensions = a_extensions;
    }

    protected RevokedCertificate(TBSCertList.CRLEntry a_crlEntry) {
        this.m_serial = a_crlEntry.getUserCertificate().getPositiveValue();
        this.m_revocationDate = a_crlEntry.getRevocationDate().getDate();
        if (a_crlEntry.getExtensions() != null) {
            this.m_extensions = new MyX509Extensions(a_crlEntry.getExtensions());
        }
    }

    protected static BigInteger getUniqueSerial(JAPCertificate a_cert) {
        if (a_cert.getSerialNumber().equals(ZERO) || a_cert.getSerialNumber().equals(ONE)) {
            return RevokedCertificate.createPseudoSerial(a_cert.toByteArray());
        }
        return a_cert.getSerialNumber();
    }

    private static BigInteger createPseudoSerial(byte[] a_rawCert) {
        SHA1Digest digest = new SHA1Digest();
        byte[] value = new byte[digest.getDigestSize()];
        digest.update(a_rawCert, 0, a_rawCert.length);
        digest.doFinal(value, 0);
        return new BigInteger(value).abs();
    }

    protected ASN1Sequence toASN1Sequence() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(this.m_serial));
        v.add(new Time(this.m_revocationDate));
        if (this.m_extensions != null) {
            v.add(this.m_extensions.getExtensionsAsBCExtensions());
        }
        return new DERSequence(v);
    }

    public BigInteger getSerialNumber() {
        return this.m_serial;
    }

    public X509DistinguishedName getCertificateIssuer() {
        X509CertificateIssuer issuer;
        if (this.m_extensions != null && (issuer = (X509CertificateIssuer)this.m_extensions.getExtension(X509CertificateIssuer.IDENTIFIER)) != null) {
            return issuer.getDistinguishedName();
        }
        return null;
    }

    public Date getRevocationDate() {
        return this.m_revocationDate;
    }

    public MyX509Extensions getExtensions() {
        return this.m_extensions;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

