/*
 * Decompiled with CFR 0.152.
 */
package anon.mixminion.message;

import anon.mixminion.EMail;
import anon.mixminion.FirstMMRConnection;
import anon.mixminion.Mixminion;
import anon.mixminion.message.Decoder;
import anon.mixminion.message.FragmentedMessage;
import anon.mixminion.message.Keyring;
import anon.mixminion.message.MessageImplementation;
import anon.mixminion.message.MixMinionCryptoUtil;
import anon.mixminion.message.NoReplyMessage;
import anon.mixminion.message.ReplyBlock;
import anon.mixminion.message.ReplyImplementation;
import anon.mixminion.message.ReplyMessage;
import anon.mixminion.message.SingleBlockMessage;
import anon.mixminion.mmrdescription.InfoServiceMMRListFetcher;
import anon.mixminion.mmrdescription.MMRDescription;
import anon.mixminion.mmrdescription.MMRList;
import anon.mixminion.mmrdescription.PlainMMRListFetcher;
import java.io.IOException;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class Message {
    private EMail m_email = null;
    private int m_hops = 0;
    private String m_address;
    private String m_decoded = null;
    private String m_keyringpassword;
    private int m_rbs;
    int MAX_FRAGMENTS_PER_CHUNK = 16;
    double EXP_FACTOR = 1.3333333333333333;

    public Message(EMail email, int hops, String myadress, String password, int rbs) {
        this.m_email = email;
        this.m_hops = hops;
        this.m_address = myadress;
        this.m_keyringpassword = password;
        this.m_rbs = rbs;
    }

    public boolean send() {
        return this.encodeMessage();
    }

    boolean encodeMessage() {
        MessageImplementation payload_imp;
        MMRList mmrlist;
        String plaintext = null;
        if (this.m_email.getType().equals("ENC")) {
            Decoder decoder = new Decoder(this.m_email.getPayload(), this.m_keyringpassword);
            Vector<String> decoded = new Vector<String>();
            try {
                plaintext = decoder.decode();
            }
            catch (IOException e2) {
                System.out.println("Decodier-Exception...");
            }
            decoded.addElement(plaintext);
            this.m_decoded = (String)decoded.elementAt(0);
            return false;
        }
        byte[][] message_parts = null;
        boolean returnValue = true;
        Vector replyblocks = null;
        if (this.m_email.getType().equals("RPL")) {
            replyblocks = this.m_email.getReplyBlocks();
        }
        if ((mmrlist = null) == null && !(mmrlist = new MMRList(new InfoServiceMMRListFetcher())).updateList()) {
            mmrlist = new MMRList(new PlainMMRListFetcher());
            if (!mmrlist.updateList()) {
                return false;
            }
            System.out.println("Groesse: " + mmrlist.size());
        }
        for (int i = 0; i < this.m_rbs; ++i) {
            Vector path_to_me = mmrlist.getByRandomWithExit(this.m_hops);
            byte[] user_secret = new Keyring(this.m_keyringpassword).getNewSecret();
            ReplyBlock reply_to_me = new ReplyBlock(this.m_address, path_to_me, user_secret);
            reply_to_me.buildBlock();
            this.m_email.addRBtoPayload(reply_to_me.getReplyBlockasString());
        }
        byte[] compressed_payload = MixMinionCryptoUtil.compressData(this.m_email.getPayload().getBytes());
        LogHolder.log(7, LogType.MISC, "[Message] Compressed Size = " + compressed_payload.length);
        if (compressed_payload.length + 22 <= 28672) {
            payload_imp = new SingleBlockMessage(compressed_payload);
        } else {
            System.out.println("fragmente!");
            payload_imp = new FragmentedMessage(this.m_email.getReceiver(), this.m_email.getPayload().getBytes());
        }
        message_parts = ((MessageImplementation)payload_imp).buildPayload();
        if (message_parts.length == 0) {
            LogHolder.log(3, LogType.MISC, "[Message] Compression failure--> 0 packets ");
            return false;
        }
        ReplyImplementation message_imp = this.m_email.getType().equals("RPL") ? new ReplyMessage(message_parts, this.m_hops, replyblocks, mmrlist) : new NoReplyMessage(message_parts, this.m_hops, this.m_email.getReceiver(), mmrlist);
        Vector packets = message_imp.buildMessage();
        Vector firstservers = message_imp.getStartServers();
        for (int i = 0; i < packets.size(); ++i) {
            returnValue = returnValue && this.sendToMixMinionServer((byte[])packets.elementAt(i), (MMRDescription)firstservers.elementAt(i));
        }
        return returnValue;
    }

    private boolean sendToMixMinionServer(byte[] message, MMRDescription description) {
        boolean returnValue = false;
        try {
            Mixminion mixminion = Mixminion.getInstance();
            FirstMMRConnection fMMRcon = new FirstMMRConnection(description, mixminion);
            System.out.println("   connecting...");
            fMMRcon.connect();
            System.out.println("   sending...");
            returnValue = fMMRcon.sendMessage(message);
            System.out.println("   Value of SendingMethod = " + returnValue);
            System.out.println("   close connection");
            fMMRcon.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    private int ceilDiv(double a, double b) {
        return (int)Math.ceil(a / b);
    }

    public String getDecoded() {
        return this.m_decoded;
    }
}

