/*
 * Decompiled with CFR 0.152.
 */
package mixconfig;

import anon.crypto.AbstractX509Extension;
import anon.crypto.ICertificate;
import anon.crypto.JAPCertificate;
import anon.crypto.MyX509Extensions;
import anon.crypto.X509BasicConstraints;
import anon.crypto.X509DistinguishedName;
import anon.crypto.X509SubjectAlternativeName;
import anon.util.CountryMapper;
import anon.util.Util;
import java.util.Vector;
import mixconfig.ICertificateView;

public class MixCertificateView
implements ICertificateView {
    private boolean m_bCA;
    private CountryMapper m_CountryMapper;
    private String m_strLocalityName;
    private String m_strStateOrProvince;
    private String m_strLongitude;
    private String m_strLatitude;
    private String m_strCommonName;

    public MixCertificateView() {
        this.update(null);
    }

    @Override
    public void update(ICertificate a_certificate) {
        Vector coordinates;
        X509SubjectAlternativeName alternativeName;
        if (a_certificate == null) {
            this.m_bCA = false;
            this.m_CountryMapper = new CountryMapper();
            this.m_strLocalityName = "";
            this.m_strStateOrProvince = "";
            this.m_strLongitude = "";
            this.m_strLatitude = "";
            this.m_strCommonName = "";
            return;
        }
        JAPCertificate certificate = a_certificate.getX509Certificate();
        X509DistinguishedName dn = certificate.getSubject();
        MyX509Extensions extensions = certificate.getExtensions();
        try {
            this.m_CountryMapper = new CountryMapper(dn.getCountryCode());
        }
        catch (IllegalArgumentException a_e) {
            // empty catch block
        }
        X509BasicConstraints extConstraints = (X509BasicConstraints)certificate.getExtensions().getExtension(X509BasicConstraints.IDENTIFIER);
        this.m_bCA = extConstraints != null && extConstraints.isCA();
        this.m_strLocalityName = this.formatDNField(dn.getLocalityName());
        this.m_strStateOrProvince = this.formatDNField(dn.getStateOrProvince());
        this.m_strCommonName = this.formatDNField(dn.getCommonName());
        AbstractX509Extension extension = extensions.getExtension(X509SubjectAlternativeName.IDENTIFIER);
        if (extension != null && extension instanceof X509SubjectAlternativeName && (alternativeName = (X509SubjectAlternativeName)extension).getTags().size() == 2 && alternativeName.getValues().size() == 2 && (coordinates = alternativeName.getTags()).elementAt(0).equals(X509SubjectAlternativeName.TAG_OTHER) && coordinates.elementAt(1).equals(X509SubjectAlternativeName.TAG_OTHER)) {
            coordinates = alternativeName.getValues();
            try {
                this.m_strLongitude = coordinates.elementAt(0).toString();
                Util.parseDouble(this.m_strLongitude);
                this.m_strLongitude = this.m_strLongitude.trim();
            }
            catch (NumberFormatException a_e) {
                this.m_strLongitude = "";
            }
            try {
                this.m_strLatitude = coordinates.elementAt(1).toString();
                Util.parseDouble(this.m_strLatitude);
                this.m_strLatitude = this.m_strLatitude.trim();
            }
            catch (NumberFormatException a_e) {
                this.m_strLatitude = "";
            }
        }
    }

    public String getLocalityName() {
        return this.m_strLocalityName;
    }

    public String getStateOrProvince() {
        return this.m_strStateOrProvince;
    }

    public CountryMapper getCountryMapper() {
        return this.m_CountryMapper;
    }

    public String getCommonName() {
        return this.m_strCommonName;
    }

    public String getCountry() {
        if (this.m_CountryMapper.getISOCode().length() == 0) {
            return "";
        }
        return this.m_CountryMapper.toString();
    }

    public String getLongitude() {
        return this.m_strLongitude;
    }

    public String getLatitude() {
        return this.m_strLatitude;
    }

    public boolean isCA() {
        return this.m_bCA;
    }

    private String formatDNField(String a_strDNField) {
        if (a_strDNField == null) {
            a_strDNField = "";
        }
        return a_strDNField.trim();
    }
}

