/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.infoservice;

import anon.util.XMLParseException;
import javax.swing.table.AbstractTableModel;
import logging.LogHolder;
import logging.LogType;
import mixconfig.infoservice.InfoServiceData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InfoServiceTableModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[]{"Host", "Port"};
    public static final int HOST = 0;
    public static final int PORT = 1;
    private InfoServiceData[] m_rows = new InfoServiceData[0];

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.m_rows.length;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void addData(InfoServiceData data) {
        InfoServiceData[] nrows = new InfoServiceData[this.m_rows.length + 1];
        for (int i = 0; i < this.m_rows.length; ++i) {
            nrows[i] = this.m_rows[i];
        }
        nrows[this.m_rows.length] = data;
        this.m_rows = nrows;
        this.fireTableRowsInserted(this.m_rows.length - 1, this.m_rows.length - 1);
    }

    public InfoServiceData getData(int index) {
        if (index < 0 || index >= this.m_rows.length) {
            return null;
        }
        return this.m_rows[index];
    }

    public void changeData(InfoServiceData data, InfoServiceData olddata) {
        for (int i = 0; i < this.m_rows.length; ++i) {
            if (this.m_rows[i] != olddata) continue;
            this.m_rows[i] = data;
            this.fireTableRowsUpdated(i, i);
            return;
        }
        this.addData(data);
    }

    public void deleteData(int index) {
        if (index >= 0 && index < this.m_rows.length) {
            int i;
            InfoServiceData[] nrows = new InfoServiceData[this.m_rows.length - 1];
            for (i = 0; i < index; ++i) {
                nrows[i] = this.m_rows[i];
            }
            for (i = index + 1; i < this.m_rows.length; ++i) {
                nrows[i - 1] = this.m_rows[i];
            }
            this.m_rows = nrows;
            this.fireTableRowsDeleted(index, index);
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        InfoServiceData data = this.getData(row);
        if (data == null) {
            return null;
        }
        switch (column) {
            case 0: {
                return data.getListenerInterface(0).getHost();
            }
            case 1: {
                return new Integer(data.getListenerInterface(0).getPort());
            }
        }
        return null;
    }

    public void clear() {
        int old = this.m_rows.length;
        this.m_rows = new InfoServiceData[0];
        this.fireTableRowsDeleted(1, old);
    }

    public Element createAsElement(Document doc) {
        Element services = doc.createElement("InfoServices");
        for (int i = 0; i < this.getRowCount(); ++i) {
            services.appendChild(this.getData(i).toXmlElement(doc));
        }
        return services;
    }

    public void readFromElement(Element infoServices) {
        if (infoServices.getTagName().equals("InfoServices")) {
            for (int i = this.getRowCount() - 1; i >= 0; --i) {
                this.deleteData(i);
            }
            for (Node child = infoServices.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1) continue;
                try {
                    InfoServiceData data = InfoServiceData.createFromElement("InfoService", (Element)child);
                    if (data == null) continue;
                    this.addData(data);
                    continue;
                }
                catch (XMLParseException e) {
                    LogHolder.log(4, LogType.NET, e.getMessage());
                }
            }
        }
    }
}

