/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.panels;

import anon.crypto.AbstractX509Extension;
import anon.crypto.MyX509Extensions;
import anon.crypto.PKCS12;
import anon.crypto.Validity;
import anon.crypto.X509AuthorityKeyIdentifier;
import anon.crypto.X509BasicConstraints;
import anon.crypto.X509DistinguishedName;
import anon.crypto.X509KeyUsage;
import anon.crypto.X509SubjectAlternativeName;
import anon.crypto.X509SubjectKeyIdentifier;
import anon.util.CountryMapper;
import anon.util.JAPMessages;
import anon.util.Util;
import gui.MapBox;
import gui.MixConfigTextField;
import gui.TitledGridBagPanel;
import gui.dialog.JAPDialog;
import gui.dialog.LinkedEmailComposer;
import gui.dialog.ValidityContentPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import logging.LogHolder;
import logging.LogType;
import mixconfig.ConfigurationEvent;
import mixconfig.FloatDocument;
import mixconfig.ICertCreationValidator;
import mixconfig.MixCertificateView;
import mixconfig.MixConfig;
import mixconfig.MixConfiguration;
import mixconfig.OperatorCertificateView;
import mixconfig.panels.CertPanel;
import mixconfig.panels.MixConfigPanel;

public class OwnCertificatesPanel
extends MixConfigPanel
implements ActionListener,
ChangeListener {
    public static final String XMLPATH_LOCATION = "Description/Location";
    public static final String XMLPATH_OPERATOR = "Description/Operator";
    public static final String XMLPATH_LOCATION_CITY = "Description/Location/City";
    public static final String XMLPATH_LOCATION_COUNTRY = "Description/Location/Country";
    public static final String XMLPATH_LOCATION_STATE = "Description/Location/State";
    public static final String XMLPATH_LOCATION_LONGITUDE = "Description/Location/Position/Geo/Longitude";
    public static final String XMLPATH_LOCATION_LATITUDE = "Description/Location/Position/Geo/Latitude";
    public static final String XMLPATH_OPERATOR_ORGANISATION = "Description/Operator/Organisation";
    public static final String XMLPATH_OPERATOR_URL = "Description/Operator/URL";
    public static final String XMLPATH_OPERATOR_EMAIL = "Description/Operator/EMail";
    public static final String XMLPATH_OPERATOR_COUNTRY = "Description/Operator/Country";
    public static final String XMLPATH_OPERATOR_CITY = "Description/Operator/City";
    public static final String XMLPATH_OPERATOR_ORGA_UNIT = "Description/Operator/OrganisationalUnit";
    public static final String MSG_INVALID_POSITION = OwnCertificatesPanel.class.getName() + "_invalidPosition";
    public static final String MSG_INVALID_EMAIL = OwnCertificatesPanel.class.getName() + "_invalidEmail";
    public static final String MSG_INVALID_URL = OwnCertificatesPanel.class.getName() + "_invalidUrl";
    private static final String MSG_CERT_NOT_VERIFYABLE = OwnCertificatesPanel.class.getName() + "_certNotVerifyable";
    private CertPanel m_ownCert;
    private CertPanel m_operatorCert;
    private JButton m_buttonMapBox;
    private JTextField m_txtCity;
    private JTextField m_txtState;
    private JTextField m_txtLongitude;
    private JTextField m_txtLatitude;
    private JTextField m_txtOperatorOrg;
    private JTextField m_txtOperatorOrgaUnit;
    private JTextField m_txtOperatorUrl;
    private JTextField m_txtOperatorEmail;
    private JComboBox m_cboxCountry;
    private JComboBox m_cbxOperatorCountry;
    private MapBox box;
    private JTextField m_txtMixName;
    private JTextField m_txtOperatorName;
    private JRadioButton m_radioMixName;
    private JRadioButton m_radioOperatorName;
    private ButtonGroup m_groupCascadeName;

    public OwnCertificatesPanel(boolean isApplet) {
        super("Certificates");
        GridBagConstraints constraints = this.getInitialConstraints();
        this.m_ownCert = new CertPanel("Own Mix Certificate", "Hint: You have to send your public certificate to the operators of adjacent mixes", (PKCS12)null, 2, 2);
        this.m_ownCert.setName("Certificates/OwnCertificate");
        this.m_ownCert.setCertCreationValidator(new OwnCertCreationValidator());
        this.m_ownCert.setCertificateView(new MixCertificateView());
        this.m_ownCert.addChangeListener(this);
        this.add((Component)this.m_ownCert, constraints);
        this.m_operatorCert = new CertPanel("Operator Certificate", "Hint: You have to send your public certificate to the operators of adjacent mixes", (PKCS12)null, 2, 2);
        this.m_operatorCert.setName("Certificates/OperatorOwnCertificate");
        this.m_operatorCert.setCertCreationValidator(new OperatorCertCreationValidator());
        this.m_operatorCert.setCertificateView(new OperatorCertificateView());
        this.m_operatorCert.addChangeListener(this);
        this.m_operatorCert.addChangeListener(this.m_ownCert);
        constraints.gridx = 1;
        this.add((Component)this.m_operatorCert, constraints);
        JPanel panelMixName = new JPanel(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 1;
        this.add((Component)panelMixName, constraints);
        this.m_txtMixName = new MixConfigTextField(20);
        this.m_txtMixName.setName("General/MixName");
        this.m_txtMixName.addFocusListener(this);
        this.m_radioMixName = new JRadioButton("show in cascade");
        this.m_radioMixName.setModel(new MixConfigPanel.ToggleButtonModel());
        this.m_radioMixName.setName("General/MixName/forCascade");
        this.m_radioMixName.addItemListener(this);
        GridBagConstraints tmpConstraints = new GridBagConstraints();
        tmpConstraints.gridx = 0;
        tmpConstraints.gridy = 0;
        tmpConstraints.insets = new Insets(5, 5, 5, 5);
        panelMixName.add((Component)new JLabel("Mix short name"), tmpConstraints);
        ++tmpConstraints.gridx;
        tmpConstraints.weightx = 1.0;
        tmpConstraints.fill = 2;
        panelMixName.add((Component)this.m_txtMixName, tmpConstraints);
        ++tmpConstraints.gridx;
        tmpConstraints.weightx = 0.0;
        tmpConstraints.insets = new Insets(5, 5, 5, 0);
        panelMixName.add((Component)this.m_radioMixName, tmpConstraints);
        JPanel panelOperatorName = new JPanel(new GridBagLayout());
        constraints.gridx = 1;
        constraints.gridy = 1;
        this.add((Component)panelOperatorName, constraints);
        this.m_txtOperatorName = new MixConfigTextField(20);
        this.m_txtOperatorName.setName("General/OperatorName");
        this.m_txtOperatorName.addFocusListener(this);
        this.m_radioOperatorName = new JRadioButton("show in cascade");
        this.m_radioOperatorName.setModel(new MixConfigPanel.ToggleButtonModel());
        this.m_radioOperatorName.setName("General/MixName/forCascade");
        this.m_radioOperatorName.addItemListener(this);
        tmpConstraints.gridx = 0;
        tmpConstraints.gridy = 0;
        tmpConstraints.insets = new Insets(5, 5, 5, 5);
        panelOperatorName.add((Component)new JLabel("Operator short name"), tmpConstraints);
        ++tmpConstraints.gridx;
        tmpConstraints.weightx = 1.0;
        tmpConstraints.fill = 2;
        panelOperatorName.add((Component)this.m_txtOperatorName, tmpConstraints);
        ++tmpConstraints.gridx;
        tmpConstraints.weightx = 0.0;
        tmpConstraints.insets = new Insets(5, 5, 5, 0);
        panelOperatorName.add((Component)this.m_radioOperatorName, tmpConstraints);
        this.m_groupCascadeName = new ButtonGroup();
        this.m_groupCascadeName.add(this.m_radioMixName);
        this.m_groupCascadeName.add(this.m_radioOperatorName);
        TitledGridBagPanel panelLocation = new TitledGridBagPanel("Mix Location");
        constraints.gridx = 0;
        constraints.gridy = 2;
        this.add((Component)panelLocation, constraints);
        this.m_txtCity = new MixConfigTextField(20);
        this.m_txtCity.setName(XMLPATH_LOCATION_CITY);
        this.m_txtCity.addFocusListener(this);
        panelLocation.addRow((Component)new JLabel("City"), (Component)this.m_txtCity, null);
        this.m_txtState = new MixConfigTextField(20);
        this.m_txtState.setName(XMLPATH_LOCATION_STATE);
        this.m_txtState.addFocusListener(this);
        panelLocation.addRow((Component)new JLabel("State"), (Component)this.m_txtState, null);
        Vector ctrVec = CountryMapper.getLocalisedCountries(27, Locale.ENGLISH);
        ctrVec.insertElementAt(new CountryMapper(27), 0);
        this.m_cboxCountry = new JComboBox(ctrVec);
        this.m_cboxCountry.setName(XMLPATH_LOCATION_COUNTRY);
        this.m_cboxCountry.addFocusListener(this);
        this.m_cboxCountry.addItemListener(this);
        this.m_cboxCountry.setEditable(false);
        panelLocation.addRow((Component)new JLabel("Country"), (Component)this.m_cboxCountry, null);
        this.m_txtLongitude = new JTextField(7);
        this.m_txtLongitude.setName(XMLPATH_LOCATION_LONGITUDE);
        this.m_txtLongitude.addFocusListener(this);
        this.m_txtLongitude.setDocument(new FloatDocument("-180.0000", "180.0000"));
        this.m_txtLongitude.setToolTipText("Longitude in degrees east of Greenwich. (-180.0000 to 180.0000)");
        this.m_txtLatitude = new JTextField(7);
        this.m_txtLatitude.setName(XMLPATH_LOCATION_LATITUDE);
        this.m_txtLatitude.addFocusListener(this);
        this.m_txtLatitude.setDocument(new FloatDocument("-90.0000", "90.0000"));
        this.m_txtLatitude.setToolTipText("Latitude in degrees. (-90.0000: South Pole, 0: Equator, 90.0000: North Pole)");
        this.m_buttonMapBox = new JButton("Show on Map");
        this.m_buttonMapBox.setToolTipText("Opens a window showing a map (using maps.google.com) of the area around the specified coordinates.");
        this.m_buttonMapBox.addActionListener(this);
        this.m_buttonMapBox.setActionCommand("Map");
        this.m_buttonMapBox.setEnabled(!isApplet);
        panelLocation.addRow((Component)new JLabel("Longitude"), (Component)this.m_txtLongitude, this.m_buttonMapBox);
        panelLocation.addRow((Component)new JLabel("Latitude"), (Component)this.m_txtLatitude, null);
        TitledGridBagPanel panelOperator = new TitledGridBagPanel("Operator");
        constraints.fill = 1;
        constraints.gridx = 1;
        constraints.gridy = 2;
        this.add((Component)panelOperator, constraints);
        this.m_txtOperatorOrg = new MixConfigTextField();
        this.m_txtOperatorOrg.setName(XMLPATH_OPERATOR_ORGANISATION);
        this.m_txtOperatorOrg.addFocusListener(this);
        this.m_txtOperatorOrg.setToolTipText("This should contain the operating organisation's or a person's name for private persons.");
        panelOperator.addRow(new JLabel("Organisation"), this.m_txtOperatorOrg);
        this.m_txtOperatorOrgaUnit = new MixConfigTextField();
        this.m_txtOperatorOrgaUnit.setName(XMLPATH_OPERATOR_ORGA_UNIT);
        this.m_txtOperatorOrgaUnit.addFocusListener(this);
        this.m_txtOperatorOrgaUnit.setToolTipText("The operator's organisational unit.");
        panelOperator.addRow(new JLabel("Orga. Unit"), this.m_txtOperatorOrgaUnit);
        this.m_cbxOperatorCountry = new JComboBox(ctrVec);
        this.m_cbxOperatorCountry.setName(XMLPATH_OPERATOR_COUNTRY);
        this.m_cbxOperatorCountry.addFocusListener(this);
        this.m_cbxOperatorCountry.addItemListener(this);
        this.m_cbxOperatorCountry.setEditable(false);
        panelOperator.addRow(new JLabel("Country"), this.m_cbxOperatorCountry);
        this.m_txtOperatorUrl = new MixConfigTextField();
        this.m_txtOperatorUrl.setName(XMLPATH_OPERATOR_URL);
        this.m_txtOperatorUrl.addFocusListener(this);
        this.m_txtOperatorUrl.setToolTipText("This should contain a URL that will lead to more information about the operator including contact information.");
        panelOperator.addRow(new JLabel("URL"), this.m_txtOperatorUrl);
        this.m_txtOperatorEmail = new MixConfigTextField();
        this.m_txtOperatorEmail.setName(XMLPATH_OPERATOR_EMAIL);
        this.m_txtOperatorEmail.addFocusListener(this);
        this.m_txtOperatorEmail.setToolTipText("An E-Mail address to which a confirmation message will be sent once the cascade is established.");
        panelOperator.addRow(new JLabel("E-Mail"), this.m_txtOperatorEmail);
        constraints.gridy = 3;
        constraints.weighty = 1.0;
        this.add((Component)new JLabel(), constraints);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            if (ae.getActionCommand().equals("Map")) {
                String lat = this.getConfiguration().getValue(XMLPATH_LOCATION_LATITUDE);
                String lon = this.getConfiguration().getValue(XMLPATH_LOCATION_LONGITUDE);
                if (lat != null && lon != null) {
                    this.box = new MapBox(MixConfig.getMainWindow(), lat, lon, 8);
                    this.box.setVisible(true);
                } else {
                    LogHolder.log(4, LogType.GUI, "Please specify latitude AND longitude!");
                }
            }
        }
        catch (Exception e) {
            JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), null, (Throwable)e);
        }
    }

    @Override
    public String getHelpContext() {
        return OwnCertificatesPanel.class.getName();
    }

    @Override
    public Vector<String> check() {
        ICertCreationValidator validator = new OwnCertCreationValidator();
        validator.isValid();
        Vector<String> errors = validator.getInvalidityMessages();
        validator = new OperatorCertCreationValidator();
        validator.isValid();
        Vector<String> tempErrors = validator.getInvalidityMessages();
        if (tempErrors.size() != 0) {
            if (errors.size() == 0) {
                errors = tempErrors;
            } else {
                for (int i = 0; i < tempErrors.size(); ++i) {
                    errors.addElement(tempErrors.elementAt(i));
                }
            }
        }
        if (this.m_ownCert.getCert() == null) {
            errors.addElement("Own mix certificate is missing in " + this.getName() + " panel.");
        }
        return errors;
    }

    @Override
    public void focusLost(FocusEvent a_event) {
        super.focusLost(a_event);
        if (a_event.getSource() instanceof JTextField) {
            this.enableComponents();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            ConfigurationEvent c;
            if (e.getSource() instanceof CertPanel) {
                this.save((CertPanel)e.getSource());
                if (e.getSource() == this.m_ownCert) {
                    MixCertificateView certView;
                    if (this.m_ownCert.getCert() != null) {
                        certView = (MixCertificateView)this.m_ownCert.getCertificateView();
                        if (certView.getCommonName().length() > 0 && !certView.getCommonName().startsWith("<Mix id=")) {
                            this.m_txtMixName.setText(certView.getCommonName());
                            this.save(this.m_txtMixName);
                        }
                        if (certView.getCountry().length() > 0) {
                            this.m_cboxCountry.setSelectedItem(certView.getCountryMapper());
                            this.save(this.m_cboxCountry);
                        }
                        if (certView.getLocalityName().length() > 0) {
                            this.m_txtCity.setText(certView.getLocalityName());
                            this.save(this.m_txtCity);
                        }
                        if (certView.getStateOrProvince().length() > 0) {
                            this.m_txtState.setText(certView.getStateOrProvince());
                            this.save(this.m_txtState);
                        }
                        if (certView.getLongitude().length() > 0) {
                            this.m_txtLongitude.setText(certView.getLongitude());
                            this.save(this.m_txtLongitude);
                        }
                        if (certView.getLatitude().length() > 0) {
                            this.m_txtLatitude.setText(certView.getLatitude());
                            this.save(this.m_txtLatitude);
                        }
                        if (this.m_operatorCert.getCert() != null && CertPanel.isAutoSign() && !this.m_ownCert.getCert().getX509Certificate().verify(this.m_operatorCert.getCert().getX509Certificate())) {
                            this.signMixCertificate(false);
                        }
                    }
                    this.updateMixID();
                    certView = (MixCertificateView)this.m_ownCert.getCertificateView();
                    if (this.m_ownCert.getCert() != null && (certView.isCA() || certView.getCountry().length() == 0 || certView.getLocalityName().length() == 0)) {
                        JAPDialog.showWarningDialog(MixConfig.getMainWindow(), JAPMessages.getString(MSG_WARNING_NO_MIX_CERT));
                    }
                } else if (e.getSource() == this.m_operatorCert) {
                    this.m_ownCert.setAdditionalVerifier(this.m_operatorCert.getCert());
                    this.m_ownCert.updateCertificateIcon(false);
                    if (this.m_operatorCert.getCert() != null) {
                        OperatorCertificateView certView = (OperatorCertificateView)this.m_operatorCert.getCertificateView();
                        if (certView.getCommonName().length() > 0) {
                            this.m_txtOperatorName.setText(certView.getCommonName());
                            this.save(this.m_txtOperatorName);
                        }
                        if (certView.getCountry().length() > 0) {
                            this.m_cbxOperatorCountry.setSelectedItem(certView.getCountryMapper());
                            this.save(this.m_cbxOperatorCountry);
                        }
                        if (certView.getEMail().length() > 0) {
                            this.m_txtOperatorEmail.setText(certView.getEMail());
                            this.save(this.m_txtOperatorEmail);
                        }
                        if (certView.getOrganisation().length() > 0) {
                            this.m_txtOperatorOrg.setText(certView.getOrganisation());
                            this.save(this.m_txtOperatorOrg);
                        }
                        if (certView.getOrganisationalUnit().length() > 0) {
                            this.m_txtOperatorOrgaUnit.setText(certView.getOrganisationalUnit());
                            this.save(this.m_txtOperatorOrgaUnit);
                        }
                        if (certView.getURL().length() > 0) {
                            this.m_txtOperatorUrl.setText(certView.getURL());
                            this.save(this.m_txtOperatorUrl);
                        }
                        if (this.m_ownCert.getCert() != null && CertPanel.isAutoSign() && !this.m_ownCert.getCert().getX509Certificate().verify(this.m_operatorCert.getCert().getX509Certificate())) {
                            this.signMixCertificate(false);
                        }
                        if (!(this.m_operatorCert.getCert() == null || certView.isCA() && certView.getCountry().length() != 0 && certView.getEMail().length() != 0 && certView.getOrganisation().length() != 0)) {
                            JAPDialog.showWarningDialog(MixConfig.getMainWindow(), JAPMessages.getString(MSG_WARNING_NO_OPERATOR_CERT));
                        }
                    }
                }
                this.enableComponents();
            } else if (e instanceof ConfigurationEvent && (c = (ConfigurationEvent)e).getModifiedXMLPath().startsWith("General/MixName")) {
                this.load();
            }
        }
        catch (Exception ex) {
            JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), null, (Throwable)ex);
        }
    }

    public boolean hasOperatorCert() {
        return this.m_operatorCert.getCert() != null;
    }

    public void signMixCertificate(boolean chooseValidity) {
        Validity validity;
        if (chooseValidity) {
            JAPDialog dialog = new JAPDialog(this, "Set a new certificate validity", true);
            ValidityContentPane contentPane = new ValidityContentPane(dialog);
            contentPane.updateDialog();
            dialog.pack();
            dialog.setResizable(false);
            dialog.setVisible(true);
            validity = contentPane.getValidity();
        } else {
            Calendar cal = Calendar.getInstance();
            validity = new Validity(cal, 1);
            LogHolder.log(7, LogType.CRYPTO, "Setting default validity: " + validity.getValidFrom() + " -- " + validity.getValidTo());
        }
        LogHolder.log(7, LogType.CRYPTO, "Signing the mix certificate ..");
        PKCS12 operatorCert = (PKCS12)this.m_operatorCert.getCert();
        Vector<AbstractX509Extension> vecExtensions = new Vector<AbstractX509Extension>();
        vecExtensions.addElement(new X509SubjectKeyIdentifier(((PKCS12)this.m_ownCert.getCert()).getPublicKey()));
        vecExtensions.addElement(new X509AuthorityKeyIdentifier(operatorCert.getPublicKey()));
        vecExtensions.addElement(new X509KeyUsage(192));
        vecExtensions.addElement(new X509BasicConstraints(false));
        MyX509Extensions extensions = new MyX509Extensions(vecExtensions);
        ((PKCS12)this.m_ownCert.getCert()).sign(operatorCert, validity, extensions, new BigInteger("0"));
        this.m_ownCert.setCert(this.m_ownCert.getCert().getX509Certificate());
        if (!this.m_ownCert.isCertificateVerifyable()) {
            JAPDialog.showMessageDialog((Component)this, JAPMessages.getString(MSG_CERT_NOT_VERIFYABLE), (JAPDialog.ILinkedInformation)new LinkedEmailComposer("Compose email to JonDos ...", this));
        }
    }

    @Override
    public void setConfiguration(MixConfiguration a_conf) throws IOException {
        this.enableComponents();
        super.setConfiguration(a_conf);
        a_conf.removeChangeListener(this);
        a_conf.addChangeListener(this);
        this.updateMixID();
        this.enableComponents();
    }

    @Override
    public Container getHelpExtractionDisplayContext() {
        return null;
    }

    @Override
    protected void save(JComboBox a_comboBox) {
        if (a_comboBox == this.m_cboxCountry || a_comboBox == this.m_cbxOperatorCountry) {
            this.getConfiguration().setValue(a_comboBox.getName(), ((CountryMapper)a_comboBox.getSelectedItem()).getISOCode());
        } else {
            super.save(a_comboBox);
        }
    }

    @Override
    public void save(JRadioButton a_cbx) {
        MixConfiguration c = this.getConfiguration();
        if (a_cbx == this.m_radioMixName && this.m_radioMixName.isSelected() && this.m_radioMixName.isEnabled() && this.isAutoSaveEnabled()) {
            c.setAttribute("General/MixName", "forCascade", "Mix");
        } else if (a_cbx == this.m_radioOperatorName && this.m_radioOperatorName.isSelected() && this.m_radioOperatorName.isEnabled() && this.isAutoSaveEnabled()) {
            c.setAttribute("General/MixName", "forCascade", "Operator");
        } else {
            super.save(a_cbx);
        }
    }

    @Override
    protected void load(JRadioButton a) {
        if (a == this.m_radioMixName || a == this.m_radioOperatorName) {
            String s = this.getConfiguration().getValue(a.getName());
            if (s == null) {
                a.setEnabled(false);
            } else if (s.equals("Mix")) {
                this.m_radioMixName.setSelected(true);
                this.m_radioMixName.setEnabled(true);
                this.m_radioOperatorName.setEnabled(true);
            } else if (s.equals("Operator")) {
                this.m_radioOperatorName.setSelected(true);
                this.m_radioMixName.setEnabled(true);
                this.m_radioOperatorName.setEnabled(true);
            } else {
                a.setEnabled(false);
            }
        } else {
            super.load(a);
        }
    }

    @Override
    protected void load(JComboBox a_comboBox) {
        if (a_comboBox == this.m_cboxCountry || a_comboBox == this.m_cbxOperatorCountry) {
            int selectedIndex = 0;
            CountryMapper cmSelected = null;
            try {
                cmSelected = new CountryMapper(this.getConfiguration().getValue(a_comboBox.getName()));
            }
            catch (IllegalArgumentException iae) {
                LogHolder.log(2, LogType.MISC, "Error: " + iae.getMessage());
            }
            if (cmSelected != null) {
                for (int i = 0; i < a_comboBox.getItemCount(); ++i) {
                    if (!cmSelected.equals(a_comboBox.getItemAt(i))) continue;
                    selectedIndex = i;
                    break;
                }
            }
            a_comboBox.setSelectedIndex(selectedIndex);
        } else {
            super.load(a_comboBox);
        }
    }

    @Override
    protected void enableComponents() {
        this.enableMixCertificateFields();
        this.enableOperatorCertificateFields();
    }

    private void enableOperatorCertificateFields() {
        OperatorCertificateView certView = (OperatorCertificateView)this.m_operatorCert.getCertificateView();
        if (this.m_operatorCert.getCert() != null && ((CountryMapper)this.m_cbxOperatorCountry.getSelectedItem()).equals(certView.getCountryMapper())) {
            this.m_cbxOperatorCountry.setEnabled(false);
        } else {
            this.m_cbxOperatorCountry.setEnabled(true);
        }
        if (certView.getEMail().length() > 0 && certView.getEMail().equals(this.m_txtOperatorEmail.getText().trim())) {
            this.m_txtOperatorEmail.setEditable(false);
        } else {
            this.m_txtOperatorEmail.setEditable(true);
        }
        if (certView.getCommonName().length() > 0 && certView.getCommonName().equals(this.m_txtOperatorName.getText().trim())) {
            this.m_txtOperatorName.setEditable(false);
        } else {
            this.m_txtOperatorName.setEditable(true);
        }
        if (certView.getOrganisation().length() > 0 && certView.getOrganisation().equals(this.m_txtOperatorOrg.getText().trim())) {
            this.m_txtOperatorOrg.setEditable(false);
        } else {
            this.m_txtOperatorOrg.setEditable(true);
        }
        if (this.m_operatorCert.getCert() != null && certView.getOrganisationalUnit().equals(this.m_txtOperatorOrgaUnit.getText().trim())) {
            this.m_txtOperatorOrgaUnit.setEditable(false);
        } else {
            this.m_txtOperatorOrgaUnit.setEditable(true);
        }
        if (this.m_operatorCert.getCert() != null && certView.getURL().equals(this.m_txtOperatorUrl.getText())) {
            this.m_txtOperatorUrl.setEditable(false);
        } else {
            this.m_txtOperatorUrl.setEditable(true);
        }
    }

    private void enableMixCertificateFields() {
        MixCertificateView certView = (MixCertificateView)this.m_ownCert.getCertificateView();
        if (certView.getCountry().length() > 0 && ((CountryMapper)this.m_cboxCountry.getSelectedItem()).equals(certView.getCountryMapper())) {
            this.m_cboxCountry.setEnabled(false);
        } else {
            this.m_cboxCountry.setEnabled(true);
        }
        if (certView.getLocalityName().length() > 0 && certView.getLocalityName().equals(this.m_txtCity.getText().trim())) {
            this.m_txtCity.setEditable(false);
        } else {
            this.m_txtCity.setEditable(true);
        }
        if (this.m_ownCert.getCert() != null && certView.getStateOrProvince().equals(this.m_txtState.getText().trim())) {
            this.m_txtState.setEditable(false);
        } else {
            this.m_txtState.setEditable(true);
        }
        if (this.m_ownCert.getCert() != null && certView.getCommonName().equals(this.m_txtMixName.getText().trim()) && certView.getCommonName().length() > 0) {
            this.m_txtMixName.setEditable(false);
        } else {
            this.m_txtMixName.setEditable(true);
        }
        if (this.m_ownCert.getCert() != null && certView.getLongitude().equals(this.m_txtLongitude.getText())) {
            this.m_txtLongitude.setEditable(false);
        } else {
            this.m_txtLongitude.setEditable(true);
        }
        if (this.m_ownCert.getCert() != null && certView.getLatitude().equals(this.m_txtLatitude.getText())) {
            this.m_txtLatitude.setEditable(false);
        } else {
            this.m_txtLatitude.setEditable(true);
        }
    }

    private void updateMixID() {
        if (this.m_ownCert == null || this.m_ownCert.getCert() == null) {
            this.save("General/MixID", null);
        } else {
            this.save("General/MixID", ((PKCS12)this.m_ownCert.getCert()).getX509Certificate().getSubjectKeyIdentifierConcatenated());
        }
    }

    private boolean checkCertificateField(String a_xmlPath, Vector<String> a_vecInvalidityMsg, Object[] msgArgs) {
        String strValue = this.getConfiguration().getValue(a_xmlPath);
        if (strValue == null || strValue.trim().equals("")) {
            a_vecInvalidityMsg.addElement(JAPMessages.getString(MSG_ERROR_BLANK_FIELD, msgArgs));
            return false;
        }
        return true;
    }

    private class OperatorCertCreationValidator
    implements ICertCreationValidator {
        private Vector<String> m_invalidity = new Vector();

        private OperatorCertCreationValidator() {
        }

        @Override
        public boolean isValid() {
            Object[] message = new String[2];
            message[1] = OwnCertificatesPanel.this.getName();
            this.m_invalidity = new Vector();
            message[0] = "Operator short name";
            OwnCertificatesPanel.this.checkCertificateField("General/OperatorName", this.m_invalidity, message);
            message[0] = "organisation";
            OwnCertificatesPanel.this.checkCertificateField(OwnCertificatesPanel.XMLPATH_OPERATOR_ORGANISATION, this.m_invalidity, message);
            message[0] = "country";
            OwnCertificatesPanel.this.checkCertificateField(OwnCertificatesPanel.XMLPATH_OPERATOR_COUNTRY, this.m_invalidity, message);
            String strValue = OwnCertificatesPanel.this.getConfiguration().getValue(OwnCertificatesPanel.XMLPATH_OPERATOR_URL);
            if (strValue != null && strValue.trim().length() > 0 && new StringTokenizer(strValue).countTokens() > 1) {
                this.m_invalidity.addElement(JAPMessages.getString(MSG_INVALID_URL, OwnCertificatesPanel.this.getName()));
            }
            message[0] = "email";
            if (!X509SubjectAlternativeName.isValidEMail(OwnCertificatesPanel.this.getConfiguration().getValue(OwnCertificatesPanel.XMLPATH_OPERATOR_EMAIL))) {
                this.m_invalidity.addElement(JAPMessages.getString(MSG_INVALID_EMAIL, OwnCertificatesPanel.this.getName()));
            }
            return this.m_invalidity.size() == 0;
        }

        @Override
        public X509DistinguishedName getSigName() {
            Hashtable<String, String> attributes = new Hashtable<String, String>();
            attributes.put(X509DistinguishedName.IDENTIFIER_CN, OwnCertificatesPanel.this.m_txtOperatorName.getText());
            attributes.put(X509DistinguishedName.IDENTIFIER_OU, OwnCertificatesPanel.this.m_txtOperatorOrgaUnit.getText());
            attributes.put(X509DistinguishedName.IDENTIFIER_O, OwnCertificatesPanel.this.m_txtOperatorOrg.getText());
            attributes.put(X509DistinguishedName.IDENTIFIER_E, OwnCertificatesPanel.this.m_txtOperatorEmail.getText());
            attributes.put(X509DistinguishedName.IDENTIFIER_C, ((CountryMapper)OwnCertificatesPanel.this.m_cbxOperatorCountry.getSelectedItem()).getISOCode());
            return new X509DistinguishedName(attributes);
        }

        @Override
        public MyX509Extensions getExtensions() {
            Vector<AbstractX509Extension> vecExtensions = new Vector<AbstractX509Extension>();
            Vector<String> vecValues = new Vector<String>();
            Vector<Integer> vecTags = new Vector<Integer>();
            String strUrl = OwnCertificatesPanel.this.getConfiguration().getValue(OwnCertificatesPanel.XMLPATH_OPERATOR_URL);
            if (strUrl != null && strUrl.trim().length() > 0) {
                vecValues.addElement(strUrl);
                vecTags.addElement(X509SubjectAlternativeName.TAG_URL);
            }
            vecValues.addElement(OwnCertificatesPanel.this.getConfiguration().getValue(OwnCertificatesPanel.XMLPATH_OPERATOR_EMAIL));
            vecTags.addElement(X509SubjectAlternativeName.TAG_EMAIL);
            vecExtensions.addElement(new X509SubjectAlternativeName(vecValues, vecTags));
            vecExtensions.addElement(new X509BasicConstraints(0));
            vecExtensions.addElement(new X509KeyUsage(196));
            return new MyX509Extensions(vecExtensions);
        }

        @Override
        public String getPasswordInfoMessage() {
            return "Your operator certificate should be protected by a strong password.";
        }

        @Override
        public Vector<String> getInvalidityMessages() {
            return this.m_invalidity;
        }
    }

    private class OwnCertCreationValidator
    implements ICertCreationValidator {
        private Vector<String> m_invalidity = new Vector();

        private OwnCertCreationValidator() {
        }

        @Override
        public boolean isValid() {
            boolean valid = true;
            MixConfiguration conf = OwnCertificatesPanel.this.getConfiguration();
            Object[] message = new String[2];
            message[1] = OwnCertificatesPanel.this.getName();
            this.m_invalidity = new Vector();
            message[0] = "Mix short name";
            valid = valid && OwnCertificatesPanel.this.checkCertificateField("General/MixName", this.m_invalidity, message);
            message[0] = "city";
            valid = valid && OwnCertificatesPanel.this.checkCertificateField(OwnCertificatesPanel.XMLPATH_LOCATION_CITY, this.m_invalidity, message);
            message[0] = "country";
            valid = valid && OwnCertificatesPanel.this.checkCertificateField(OwnCertificatesPanel.XMLPATH_LOCATION_COUNTRY, this.m_invalidity, message);
            String strLongitude = conf.getValue(OwnCertificatesPanel.XMLPATH_LOCATION_LONGITUDE);
            String strLatitude = conf.getValue(OwnCertificatesPanel.XMLPATH_LOCATION_LATITUDE);
            if (strLongitude != null && strLongitude.length() > 0 || strLatitude != null && strLatitude.length() > 0) {
                try {
                    Util.parseDouble(strLongitude);
                    Util.parseDouble(strLatitude);
                }
                catch (NumberFormatException a_e) {
                    this.m_invalidity.addElement(JAPMessages.getString(MSG_INVALID_POSITION, OwnCertificatesPanel.this.getName()));
                    valid = false;
                }
            }
            return valid;
        }

        @Override
        public X509DistinguishedName getSigName() {
            Hashtable<String, String> attributes = new Hashtable<String, String>();
            attributes.put(X509DistinguishedName.IDENTIFIER_CN, OwnCertificatesPanel.this.m_txtMixName.getText());
            attributes.put(X509DistinguishedName.IDENTIFIER_ST, OwnCertificatesPanel.this.m_txtState.getText());
            attributes.put(X509DistinguishedName.IDENTIFIER_L, OwnCertificatesPanel.this.m_txtCity.getText());
            attributes.put(X509DistinguishedName.IDENTIFIER_C, ((CountryMapper)OwnCertificatesPanel.this.m_cboxCountry.getSelectedItem()).getISOCode());
            return new X509DistinguishedName(attributes);
        }

        @Override
        public MyX509Extensions getExtensions() {
            Vector<String> coordinates = new Vector<String>();
            Vector<Integer> tags = new Vector<Integer>();
            Vector<AbstractX509Extension> vecExtensions = new Vector<AbstractX509Extension>();
            String strLongitude = OwnCertificatesPanel.this.getConfiguration().getValue(OwnCertificatesPanel.XMLPATH_LOCATION_LONGITUDE);
            String strLatitude = OwnCertificatesPanel.this.getConfiguration().getValue(OwnCertificatesPanel.XMLPATH_LOCATION_LATITUDE);
            if (strLongitude != null && strLongitude.length() > 0 && strLatitude != null && strLatitude.length() > 0) {
                coordinates.addElement(strLongitude);
                coordinates.addElement(strLatitude);
                tags.addElement(X509SubjectAlternativeName.TAG_OTHER);
                tags.addElement(X509SubjectAlternativeName.TAG_OTHER);
                vecExtensions.addElement(new X509SubjectAlternativeName(coordinates, tags));
            }
            vecExtensions.addElement(new X509KeyUsage(192));
            return new MyX509Extensions(vecExtensions);
        }

        @Override
        public String getPasswordInfoMessage() {
            return "This password has to be entered every time the Mix server starts.\nSo if you want to start it automatically you shouldn't enter a password.";
        }

        @Override
        public Vector<String> getInvalidityMessages() {
            return this.m_invalidity;
        }
    }
}

