/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AbstractX509Extension;
import anon.crypto.X509DistinguishedName;
import anon.util.Util;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;

public class X509CertificateIssuer
extends AbstractX509Extension {
    public static final String IDENTIFIER = X509Extensions.CertificateIssuer.getId();
    private X509DistinguishedName m_issuer;

    public X509CertificateIssuer(X509DistinguishedName x509DistinguishedName) {
        super(IDENTIFIER, true, X509CertificateIssuer.createDEROctets(x509DistinguishedName));
        this.m_issuer = x509DistinguishedName;
    }

    public X509CertificateIssuer(DERSequence dERSequence) {
        super(dERSequence);
        this.createValue();
    }

    private static byte[] createDEROctets(X509DistinguishedName x509DistinguishedName) {
        return new GeneralNames(new GeneralName(x509DistinguishedName.getX509Name())).getDEREncoded();
    }

    public String getName() {
        return "CertificateIssuer";
    }

    private void createValue() {
        try {
            DERSequence dERSequence = (DERSequence)new ASN1InputStream((InputStream)new ByteArrayInputStream(this.getDEROctets())).readObject();
            GeneralName generalName = new GeneralNames((ASN1Sequence)dERSequence).getNames()[0];
            if (generalName.getTagNo() != 4) {
                throw new Exception();
            }
            dERSequence = (DERSequence)generalName.getName();
            this.m_issuer = new X509DistinguishedName(new X509Name((ASN1Sequence)dERSequence));
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not read certificate issuer extension from byte array!");
        }
    }

    public Vector getValues() {
        return Util.toVector(this.m_issuer.toString());
    }

    public boolean equalsIssuer(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof X509DistinguishedName || object instanceof X509Name) {
            return this.m_issuer.equals(object);
        }
        return false;
    }

    public X509DistinguishedName getDistinguishedName() {
        return this.m_issuer;
    }
}

