/*
 * Decompiled with CFR 0.152.
 */
package anon.mixminion.message;

import anon.crypto.MyAES;
import anon.util.ByteArrayUtil;
import anon.util.ZLibTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class MixMinionCryptoUtil {
    public static byte[] randomArray(int n) {
        byte[] byArray = new byte[n];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    static byte[] xor(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return null;
        }
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }

    public static byte[] hash(byte[] byArray) {
        SHA1Digest sHA1Digest = new SHA1Digest();
        sHA1Digest.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray2, 0);
        return byArray2;
    }

    public static Vector subVector(Vector vector, int n, int n2) {
        Vector vector2 = new Vector();
        for (int i = n; i < n + n2; ++i) {
            vector2.addElement(vector.elementAt(i));
        }
        return vector2;
    }

    public static byte[] Encrypt(byte[] byArray, byte[] byArray2) {
        return MixMinionCryptoUtil.xor(byArray2, MixMinionCryptoUtil.createPRNG(byArray, byArray2.length));
    }

    static byte[] createPRNG(byte[] byArray, int n) {
        MyAES myAES = new MyAES();
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = new byte[16];
        try {
            myAES.init(true, byArray);
            int n2 = 0;
            while (n >= 16) {
                myAES.processBlockECB(byArray3, byArray4);
                System.arraycopy(byArray4, 0, byArray2, n2, 16);
                int n3 = 1;
                for (int i = byArray3.length - 1; i >= 0; --i) {
                    int n4 = (byArray3[i] & 0xFF) + n3;
                    n3 = n4 > 255 ? 1 : 0;
                    byArray3[i] = (byte)n4;
                }
                n -= 16;
                n2 += 16;
            }
            if (n > 0) {
                myAES.processBlockECB(byArray3, byArray4);
                System.arraycopy(byArray4, 0, byArray2, n2, n);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
        return byArray2;
    }

    public static byte[] SPRP_Encrypt(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[20];
        byte[] byArray4 = byArray;
        byArray3[19] = 1;
        byte[] byArray5 = MixMinionCryptoUtil.xor(byArray, byArray3);
        byArray3[19] = 2;
        byte[] byArray6 = MixMinionCryptoUtil.xor(byArray, byArray3);
        byArray3[19] = 3;
        byte[] byArray7 = MixMinionCryptoUtil.xor(byArray, byArray3);
        byte[] byArray8 = ByteArrayUtil.copy(byArray2, 0, 20);
        byte[] byArray9 = ByteArrayUtil.copy(byArray2, 20, byArray2.length - 20);
        byArray9 = MixMinionCryptoUtil.Encrypt(ByteArrayUtil.copy(MixMinionCryptoUtil.hash(ByteArrayUtil.conc(byArray4, byArray8, byArray4)), 0, 16), byArray9);
        byArray8 = MixMinionCryptoUtil.xor(byArray8, MixMinionCryptoUtil.hash(ByteArrayUtil.conc(byArray5, byArray9, byArray5)));
        byArray9 = MixMinionCryptoUtil.Encrypt(ByteArrayUtil.copy(MixMinionCryptoUtil.hash(ByteArrayUtil.conc(byArray6, byArray8, byArray6)), 0, 16), byArray9);
        byArray8 = MixMinionCryptoUtil.xor(byArray8, MixMinionCryptoUtil.hash(ByteArrayUtil.conc(byArray7, byArray9, byArray7)));
        return ByteArrayUtil.conc(byArray8, byArray9);
    }

    public static byte[] SPRP_Decrypt(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[20];
        byte[] byArray4 = byArray;
        byArray3[19] = 1;
        byte[] byArray5 = MixMinionCryptoUtil.xor(byArray, byArray3);
        byArray3[19] = 2;
        byte[] byArray6 = MixMinionCryptoUtil.xor(byArray, byArray3);
        byArray3[19] = 3;
        byte[] byArray7 = MixMinionCryptoUtil.xor(byArray, byArray3);
        byte[] byArray8 = ByteArrayUtil.copy(byArray2, 0, 20);
        byte[] byArray9 = ByteArrayUtil.copy(byArray2, 20, byArray2.length - 20);
        byArray8 = MixMinionCryptoUtil.xor(byArray8, MixMinionCryptoUtil.hash(ByteArrayUtil.conc(byArray7, byArray9, byArray7)));
        byArray9 = MixMinionCryptoUtil.Encrypt(ByteArrayUtil.copy(MixMinionCryptoUtil.hash(ByteArrayUtil.conc(byArray6, byArray8, byArray6)), 0, 16), byArray9);
        byArray8 = MixMinionCryptoUtil.xor(byArray8, MixMinionCryptoUtil.hash(ByteArrayUtil.conc(byArray5, byArray9, byArray5)));
        byArray9 = MixMinionCryptoUtil.Encrypt(ByteArrayUtil.copy(MixMinionCryptoUtil.hash(ByteArrayUtil.conc(byArray4, byArray8, byArray4)), 0, 16), byArray9);
        return ByteArrayUtil.conc(byArray8, byArray9);
    }

    static byte[] compressData(byte[] byArray) {
        byte[] byArray2 = ZLibTools.compress(byArray);
        if (byArray2[0] != 120 || byArray2[1] + 256 != 218) {
            throw new RuntimeException("The Compressed Messege didn't start with 0x78DA");
        }
        return byArray2;
    }

    static byte[] decompressData(byte[] byArray) {
        return ZLibTools.decompress(byArray);
    }

    private static byte[] ZIPcompressData(byte[] byArray) {
        byte[] byArray2 = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            zipOutputStream.setLevel(9);
            zipOutputStream.setMethod(8);
            ZipEntry zipEntry = new ZipEntry("MixMinionZip");
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(byArray);
            ((FilterOutputStream)zipOutputStream).flush();
            zipOutputStream.close();
            byteArrayOutputStream.flush();
            ((OutputStream)byteArrayOutputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byArray2 = byteArrayOutputStream.toByteArray();
        if (!ByteArrayUtil.equal(byArray, MixMinionCryptoUtil.ZIPextractData(byArray2))) {
            throw new RuntimeException("Something with Compression/Decompression was wrong!");
        }
        return byArray2;
    }

    private static byte[] ZIPextractData(byte[] byArray) {
        byte[] byArray2 = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            ZipInputStream zipInputStream = new ZipInputStream(byteArrayInputStream);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            boolean bl = true;
            int n = -1;
            while (bl) {
                ++n;
                int n2 = ((InflaterInputStream)zipInputStream).read();
                byte[] byArray3 = new byte[]{(byte)n2};
                if (n2 != -1) {
                    byArray2 = ByteArrayUtil.conc(byArray2, byArray3);
                    continue;
                }
                bl = false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray2;
    }

    private static byte[] GZIPcompressData(byte[] byArray) {
        byte[] byArray2 = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            ((FilterOutputStream)gZIPOutputStream).flush();
            gZIPOutputStream.close();
            byteArrayOutputStream.flush();
            ((OutputStream)byteArrayOutputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    private static byte[] GZIPextractData(byte[] byArray) {
        byte[] byArray2 = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            boolean bl = true;
            int n = -1;
            while (bl) {
                ++n;
                int n2 = gZIPInputStream.read();
                byte[] byArray3 = new byte[]{(byte)n2};
                if (n2 != -1) {
                    byArray2 = ByteArrayUtil.conc(byArray2, byArray3);
                    continue;
                }
                bl = false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray2;
    }
}

